<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\BusinessSummary;
use App\Models\Withdraw;

class WithdrawsController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $summaries = BusinessSummary::all();

        return view('withdraws.index',compact('summaries'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'person' => 'required',
            'amount' => 'required',
        ]);

        try{
            \DB::beginTransaction();
            $summary = BusinessSummary::find($request->summary_id);

            $request->amount = str_replace(',','',$request->amount);

            $withdraw = new Withdraw;
            $withdraw->business_summary_id = $request->summary_id;
            $withdraw->person = $request->person;
            $withdraw->date = $summary->date;
            $withdraw->amount = $request->amount;
            $withdraw->narration = $request->narration;
            $withdraw->save();

            $summary->withdrawals += $request->amount;
            $summary->balance = $summary->collections - $summary->withdrawals;
            $summary->save(); 
            \DB::commit();

            return redirect()->back()->with('success','Withdraw added successfully!');
        }catch(\Throwable $ex){
            return $ex->getMessage();
            return redirect()->back()->withErrors(['error'=>$ex->getMessage()])->withInput();
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        $summary = BusinessSummary::find($id);
        return view('withdraws.show',compact('summary'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
