<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ApprovalStep extends Model
{
    use HasFactory;

    /**
     * Query scope business.
     *
     * @param  \Illuminate\Database\Eloquent\Builder
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeBusiness($query)
    {
        return $query->where('business_id',\Auth::user()->business_id);
    }

    protected $fillable = [
        'business_id', 
        'invoice_id', 
        'load_bom_id',
        'approval_id', 
        'user_id', 
        'requisition_id',
        'leave_id',
        'status'
    ];

    /**
     * ApprovalStep belongs to Invoice.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function invoice()
    {
        // belongsTo(RelatedModel, foreignKey = invoice_id, keyOnRelatedModel = id)
        return $this->belongsTo(Invoice::class);
    }

    /**
     * ApprovalStep belongs to Load_bom.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function load_bom()
    {
        // belongsTo(RelatedModel, foreignKey = load_bom_id, keyOnRelatedModel = id)
        return $this->belongsTo(LoadBom::class);
    }

    /**
     * ApprovalStep belongs to Approval.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function approval()
    {
        // belongsTo(RelatedModel, foreignKey = approval_id, keyOnRelatedModel = id)
        return $this->belongsTo(Approval::class);
    }

    /**
     * ApprovalStep belongs to Requisition.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function requisition()
    {
        // belongsTo(RelatedModel, foreignKey = requisition_id, keyOnRelatedModel = id)
        return $this->belongsTo(Requisition::class);
    }

    /**
     * ApprovalStep belongs to Leave.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function leave()
    {
        // belongsTo(RelatedModel, foreignKey = leave_id, keyOnRelatedModel = id)
        return $this->belongsTo(Leave::class);
    }
}
