<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Collection extends Model
{
    use HasFactory;

    /**
     * Collection belongs to Personel.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function personel()
    {
        // belongsTo(RelatedModel, foreignKey = personel_id, keyOnRelatedModel = id)
        return $this->belongsTo(Personel::class);
    }

    /**
     * Collection belongs to Branch.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function branch()
    {
        // belongsTo(RelatedModel, foreignKey = branch_id, keyOnRelatedModel = id)
        return $this->belongsTo(Branch::class);
    }

    /**
     * Collection belongs to Customer.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function customer()
    {
        // belongsTo(RelatedModel, foreignKey = customer_id, keyOnRelatedModel = id)
        return $this->belongsTo(Customer::class);
    }

    /**
     * Collection belongs to Summary.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function summary()
    {
        // belongsTo(RelatedModel, foreignKey = summary_id, keyOnRelatedModel = id)
        return $this->belongsTo(Summary::class);
    }
}
