<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Credit extends Model
{
    use HasFactory;

    /**
     * Credit belongs to Customer.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function customer()
    {
        // belongsTo(RelatedModel, foreignKey = customer_id, keyOnRelatedModel = id)
        return $this->belongsTo(Customer::class);
    }

    /**
     * Credit belongs to Branch.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function branch()
    {
        // belongsTo(RelatedModel, foreignKey = branch_id, keyOnRelatedModel = id)
        return $this->belongsTo(Branch::class);
    }

    /**
     * Credit belongs to Inventory.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function inventory()
    {
        // belongsTo(RelatedModel, foreignKey = inventory_id, keyOnRelatedModel = id)
        return $this->belongsTo(Inventory::class);
    }

    /**
     * Credit belongs to Summary.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function summary()
    {
        // belongsTo(RelatedModel, foreignKey = summary_id, keyOnRelatedModel = id)
        return $this->belongsTo(Summary::class);
    }
}
