<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Customer extends Model
{
    use HasFactory,softDeletes;

    /**
     * Customer has many Credits.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function credits()
    {
        // hasMany(RelatedModel, foreignKeyOnRelatedModel = customer_id, localKey = id)
        return $this->hasMany(Credit::class);
    }

    /**
     * Customer has many Payments.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function payments()
    {
        // hasMany(RelatedModel, foreignKeyOnRelatedModel = customer_id, localKey = id)
        return $this->hasMany(Payment::class);
    }

    /**
     * Customer has many Collections.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function collections()
    {
        // hasMany(RelatedModel, foreignKeyOnRelatedModel = customer_id, localKey = id)
        return $this->hasMany(Collection::class);
    }

    public function suspenseTransactions(){
        return $this->hasMany(SuspenseAccount::class);
    }
}
