<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Discount extends Model
{
    use HasFactory;

    /**
     * Discount belongs to Customer.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function customer()
    {
        // belongsTo(RelatedModel, foreignKey = customer_id, keyOnRelatedModel = id)
        return $this->belongsTo(Customer::class);
    }

    /**
     * Discount belongs to Inventory.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function inventory()
    {
        // belongsTo(RelatedModel, foreignKey = inventory_id, keyOnRelatedModel = id)
        return $this->belongsTo(Inventory::class);
    }

    /**
     * Discount belongs to Summary.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function summary()
    {
        // belongsTo(RelatedModel, foreignKey = summary_id, keyOnRelatedModel = id)
        return $this->belongsTo(Summary::class);
    }
}
