<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Intake extends Model
{
    use HasFactory;

    /**
     * Intake belongs to Supplier.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function supplier()
    {
        // belongsTo(RelatedModel, foreignKey = supplier_id, keyOnRelatedModel = id)
        return $this->belongsTo(Supplier::class);
    }

    /**
     * Intake belongs to Branch.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function branch()
    {
        // belongsTo(RelatedModel, foreignKey = branch_id, keyOnRelatedModel = id)
        return $this->belongsTo(Branch::class);
    }

    /**
     * Intake belongs to Inventory.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function inventory()
    {
        // belongsTo(RelatedModel, foreignKey = inventory_id, keyOnRelatedModel = id)
        return $this->belongsTo(Inventory::class);
    }

    /**
     * Intake belongs to Summary.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function summary()
    {
        // belongsTo(RelatedModel, foreignKey = summary_id, keyOnRelatedModel = id)
        return $this->belongsTo(Summary::class);
    }
}
