<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Payment extends Model
{
    use HasFactory,SoftDeletes;

    /**
     * Payment belongs to Customer.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function customer()
    {
        // belongsTo(RelatedModel, foreignKey = customer_id, keyOnRelatedModel = id)
        return $this->belongsTo(Customer::class);
    }

    /**
     * Payment belongs to Supplier.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function supplier()
    {
        // belongsTo(RelatedModel, foreignKey = supplier_id, keyOnRelatedModel = id)
        return $this->belongsTo(Supplier::class);
    }

    public function recovery()
    {
        return $this->belongsTo(Recovery::class);
    }

    public function disbursement()
    {
        return $this->belongsTo(Disbursement::class);
    }

    public function ledger()
    {
        return $this->hasOne(Ledger::class);
    }
}
