<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Summary extends Model
{
    use HasFactory,softDeletes;

    /**
     * Summary belongs to Branch.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function branch()
    {
        // belongsTo(RelatedModel, foreignKey = branch_id, keyOnRelatedModel = id)
        return $this->belongsTo(Branch::class);
    }

    /**
     * Summary belongs to Personel.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function personel()
    {
        // belongsTo(RelatedModel, foreignKey = personel_id, keyOnRelatedModel = id)
        return $this->belongsTo(Personel::class);
    }

    /**
     * Summary belongs to User.
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function user()
    {
        // belongsTo(RelatedModel, foreignKey = user_id, keyOnRelatedModel = id)
        return $this->belongsTo(User::class);
    }

    /**
     * Summary has many Collections.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function collections()
    {
        // hasMany(RelatedModel, foreignKeyOnRelatedModel = summary_id, localKey = id)
        return $this->hasMany(Collection::class);
    }

    /**
     * Summary has many Credits.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function credits()
    {
        // hasMany(RelatedModel, foreignKeyOnRelatedModel = summary_id, localKey = id)
        return $this->hasMany(Credit::class);
    }

    /**
     * Summary has many Discounts.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function summary_discounts()
    {
        // hasMany(RelatedModel, foreignKeyOnRelatedModel = summary_id, localKey = id)
        return $this->hasMany(Discount::class);
    }

    /**
     * Summary has many Intakes.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function intakes()
    {
        // hasMany(RelatedModel, foreignKeyOnRelatedModel = summary_id, localKey = id)
        return $this->hasMany(Intake::class);
    }

    /**
     * Summary has many Transfers.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function summary_transfers()
    {
        // hasMany(RelatedModel, foreignKeyOnRelatedModel = summary_id, localKey = id)
        return $this->hasMany(Transfer::class);
    }

    /**
     * Summary has many Expenses.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function summary_expenses()
    {
        // hasMany(RelatedModel, foreignKeyOnRelatedModel = summary_id, localKey = id)
        return $this->hasMany(Expense::class);
    }

    /**
     * Summary has many Recoveries.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function recoveries()
    {
        // hasMany(RelatedModel, foreignKeyOnRelatedModel = summary_id, localKey = id)
        return $this->hasMany(Recovery::class);
    }

    /**
     * Summary has many Profits.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function summary_profits()
    {
        // hasMany(RelatedModel, foreignKeyOnRelatedModel = summary_id, localKey = id)
        return $this->hasMany(Profit::class);
    }
}
