<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('summaries', function (Blueprint $table) {
            $table->id();
            $table->integer('branch_id');
            $table->string('date');
            $table->string('opening_balance')->default(0);
            $table->string('closing_balance')->default(0);
            $table->string('profits')->default(0);
            $table->string('transfers')->default(0);
            $table->string('total_sales')->default(0);
            $table->string('intake')->default(0);
            $table->string('credit_sales')->default(0);
            $table->string('discounts')->default(0);
            $table->string('expenses')->default(0);
            $table->enum('status',['Open','Closed','Editted'])->default('Open');
            $table->string('stage')->default('Branch');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('summaries');
    }
};
