<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('ledgers', function (Blueprint $table) {
             $table->integer('credit_id')->nullable()->change(); 
             $table->integer('collection_id')->nullable()->after('credit_id'); 
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('ledgers', function (Blueprint $table) {
             $table->integer('credit_id')->nullable(false)->change(); 
             $table->dropColumn('collection_id'); 
        });
    }
};
