<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('general_expenses', function (Blueprint $table) {
            $table->id();
            $table->string('expense_date');
            $table->string('reference')->nullable();
            $table->integer('supplier_id');
            $table->integer('expense_item_id');
            $table->integer('payment_method_id');
            $table->string('amount');
            $table->string('paid_amount');
            $table->string('balance');
            $table->string('narration')->nullable();
            $table->string('status');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('general_expenses');
    }
};
