@extends('layouts.app')
@section('breadcrumb')
<div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
	<h4 class="mb-sm-0">Daily Summaries</h4>
	<div class="page-title-right">
		<ol class="breadcrumb m-0">
			<li class="breadcrumb-item"><a href="{{ url('dashboard') }}">Dashboard</a></li>
			<li class="breadcrumb-item"><a href="{{ url('summaries') }}">Daily Summaries</a></li>
			<li class="breadcrumb-item"><a href="javascript:void(0);">{{ $summary->branch?->name }}</a></li>
			<li class="breadcrumb-item"><a href="{{ url('summaries/modules/'.$summary->id) }}">{{ date('d M, Y',strtotime($summary->date)) }}</a></li>
			<li class="breadcrumb-item active">Collections</li>
		</ol>
	</div>
</div>
@endsection
@section('content')
<div class="card">
	<div class="card-header">
		@include('layouts.summaries_menu')
	</div>
	<div class="card-body">
		<form id="collectionForm" action="{{ url('collections') }}" method="POST">
			@csrf
			<input type="hidden" name="summary_id" value="{{ $summary->id }}">
			<div class="repeater">
				<table class="table">
					<thead>
						<tr>
							<th>Personel</th>
							<th>Amount</th>
							<th></th>
						</tr>
					</thead>
					<tbody data-repeater-list="items">
						<tr id="1" data-repeater-item>
							<td width="60%">
								<select class="form-control select-personel" name="personel_id" required>
									<option></option>
									@foreach($personels as $personel)
										<option value="{{ $personel['id'] }}">{{ $personel['name'] }}</option>
									@endforeach
								</select>
								<textarea class="form-control reason" name="reason" placeholder="Reason" aria-label="Reason"></textarea>
							</td>
							<td width="30%">
								<input type="text" name="amount" class="form-control amount" required aria-label="Amount">
							</td>
							<td width="10%">
								<button type="button" data-repeater-delete class="btn btn-danger" aria-label="Delete">Delete</button>
							</td>
						</tr>
					</tbody>
				</table>
				<button type="button" data-repeater-create class="btn btn-primary" aria-label="Add">Add</button>
			</div>
			<div class="mt-4">
				<div class="row">
					<div class="col-md-3 offset-md-9">
						<div class="form-group">
							<label for="grand-total">Grand Total:</label>
							<input type="text" id="grand-total" class="form-control" disabled aria-label="Grand Total">
						</div>
					</div>
				</div>
			</div>
			<div class="d-flex mt-4 flex-row align-items-center justify-content-between">
				<a href="{{ url('summaries') }}" class="btn btn-info" aria-label="Cancel">Cancel</a>
				<button type="button" id="previewButton" class="btn btn-success" aria-label="Next">Save</button>
			</div>
		</form>
	</div>
</div>

<!-- Preview Modal -->
<div class="modal fade" id="previewModal" tabindex="-1" aria-labelledby="previewModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content">
			<div class="modal-header">
				<h5 class="modal-title" id="previewModalLabel">Preview Entries</h5>
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
			</div>
			<div class="modal-body">
				<table class="table">
					<thead>
						<tr>
							<th>Personel</th>
							<th>Amount</th>
							<th>Reason</th>
						</tr>
					</thead>
					<tbody id="previewBody">
						<!-- Entries will be populated here -->
					</tbody>
				</table>
				<div class="form-group mt-3">
					<label for="modal-grand-total">Grand Total:</label>
					<input type="text" id="modal-grand-total" class="form-control" disabled>
				</div>
			</div>
			<div class="modal-footer flex-row align-items-center justify-content-between">
				<button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Back</button>
				<button type="button" id="confirmButton" class="btn btn-primary">Confirm</button>
			</div>
		</div>
	</div>
</div>
@endsection

@section('customjs')
<script type="text/javascript">
	$(document).ready(function () {
		$('.select-personel').select2();
		var $repeater = $('.repeater').repeater({
			initEmpty: true,
			show: function () {
				$(this).slideDown();
				$('.select2-container').remove();
				$('.select-personel').select2();
				bindEvents($(this));
			},
			hide: function (deleteElement) {
				$(this).slideUp(deleteElement, function() {
					$(this).remove();
					calculateGrandTotal();
				});
			}
		});

		@if(old('items'))
			$repeater.setList(@json(old('items')));
		@elseif($collections->count() > 0)
			$repeater.setList([
				@foreach ($collections as $collection)
				{
					'personel_id' : '{{ $collection->collector_id }}',
					'amount': '{{ $collection->amount }}',
					'reason': '{{ $collection->reason }}',
				},
				@endforeach
			]);
		@endif

		calculateGrandTotal();

		function bindEvents(item) {
			item.find('.amount').on('input', function() {
				formatNumber($(this));
				calculateGrandTotal();
			});
		}

		function formatNumber(input) {
			var value = input.val().replace(/,/g, '');
			if (!isNaN(value) && value !== '') {
				value = parseFloat(value).toLocaleString();
				input.val(value);
			}
		}

		function calculateGrandTotal() {
			var grandTotal = 0;
			$('.repeater .amount').each(function() {
				var value = $(this).val().replace(/,/g, '');
				var total = parseFloat(value) || 0;
				grandTotal += total;
			});
			$('#grand-total').val(grandTotal.toLocaleString());
		}

		// Show Preview Modal
		$('#previewButton').on('click', function () {
			var previewBody = $('#previewBody');
			previewBody.empty();

			$('.repeater [data-repeater-item]').each(function() {
				var personel = $(this).find('.select-personel option:selected').text();
				var amount = $(this).find('.amount').val();
				var reason = $(this).find('.reason').val();

				previewBody.append('<tr>'+
					'<td>'+personel+'</td>'+
					'<td>'+amount+'</td>'+
					'<td>'+reason+'</td>'+
				'</tr>');
			});

			$('#modal-grand-total').val($('#grand-total').val());
			$('#previewModal').modal('show');
		});

		// Confirm and Submit Form
		$('#confirmButton').on('click', function () {
			$('#collectionForm').submit();
		});
	});
</script>
@endsection