@extends('layouts.app')
@section('content')
<div class="card">
	<form class="card-body">
		<div class="row">
			<div class="col-md-4">
				<label>Date</label>
				<input type="date" class="form-control" name="date">
			</div>
			<div class="col-md-4">
				<label>Personel</label>
				<select class="select2" name="personel_id">
					<option></option>
					@foreach($personels as $personel)
					<option value="{{ $personel->id }}">{{ $personel->name }}</option>
					@endforeach
				</select>
			</div>

			<div class="col-md-4">
				<label>Branch</label>
				<select class="select2" name="branch_id">
					<option></option>
					@foreach($branches as $branch)
					<option value="{{ $branch->id }}">{{ $branch->name }}</option>
					@endforeach
				</select>
				<div class="text-end">
					<button type="submit" class="btn btn-success">Search</button>
				</div>
			</div>
		</div>
	</form>
</div>
<div class="card">
	<div class="card-header">
		<h5 class="card-title">Collections</h5>
	</div>
	<div class="card-body">
		<div class="table-responsive">
			<table class="table dataTable">
				<thead>
					<th>Date</th>
					<th>Branch</th>
					<th>Personel</th>
					<th>Amount</th>
				</thead>
				<tbody>
					@foreach($collections as $collection)
						<tr>
							<td>{{ date('d M, Y',strtotime($collection->date)) }}</td>
							<td>{{ $collection?->branch?->name }}</td>
							<td>{{ $collection?->personel?->name }}</td>
							<td>{{ $collection->amount ? number_format($collection->amount) : 0 }}</td>
						</tr>
					@endforeach
				</tbody>
			</table>
		</div>
	</div>
</div>
@endsection