@extends('layouts.app')
@section('content')
<div class="card">
	<form class="card-body">
		<div class="row">
			<div class="col-md-4">
				<label>Date</label>
				<input type="date" class="form-control" name="date">
			</div>
			<div class="col-md-4">
				<label>Customer</label>
				<select class="select2" name="customer_id">
					<option></option>
					@foreach($customers as $customer)
					<option value="{{ $customer->id }}">{{ $customer->name }}</option>
					@endforeach
				</select>
			</div>

			<div class="col-md-4">
				<label>Branch</label>
				<select class="select2" name="branch_id">
					<option></option>
					@foreach($branches as $branch)
					<option value="{{ $branch->id }}">{{ $branch->name }}</option>
					@endforeach
				</select>
				<div class="text-end">
					<button type="submit" class="btn btn-success">Search</button>
				</div>
			</div>
		</div>
	</form>
</div>
<div class="card">
	<div class="card-header">
		<h5 class="card-title">Credits</h5>
	</div>
	<div class="card-body">
		<div class="table-responsive">
			<table class="table dataTable">
				<thead>
				    <th>ID</th>
					<th>Date</th>
					<th>Branch</th>
					<th>Customer</th>
					<th>Amount</th>
				</thead>
				<tbody>
					@foreach($credits as $credit)
						<tr>
						    <td>{{$credit->id}}</td>
							<td>{{ date('d M, Y',strtotime($credit->date)) }}</td>
							<td>{{ $credit?->branch?->name }}</td>
							<td>{{ $credit?->customer?->name }}</td>
							<td>{{ $credit->amount ? number_format($credit->amount) : 0 }}</td>
						</tr>
					@endforeach
				</tbody>
			</table>
		</div>
	</div>
</div>
@endsection