@extends('customers.layout')

@section('customers.content')
<div class="container">
    <div class="card">
        <div class="card-body">
            <!-- Nav tabs -->
            <ul class="nav nav-pills nav-justified mb-3" role="tablist">
                <li class="nav-item waves-effect waves-light">
                    <a class="nav-link active" data-bs-toggle="tab" href="#pill-justified-home-1" role="tab">
                        Customer Details
                    </a>
                </li>
                <li class="nav-item waves-effect waves-light">
                    <a class="nav-link" data-bs-toggle="tab" href="#pill-justified-profile-1" role="tab">
                        Credits
                    </a>
                </li>
                <li class="nav-item waves-effect waves-light">
                    <a class="nav-link" data-bs-toggle="tab" href="#pill-justified-messages-1" role="tab">
                        Payments
                    </a>
                </li>
                {{-- <li class="nav-item waves-effect waves-light">
                    <a class="nav-link" data-bs-toggle="tab" href="#pill-justified-settings-1" role="tab">
                        Settings
                    </a>
                </li> --}}
            </ul>
            <!-- Tab panes -->
            <div class="tab-content ">
                <div class="tab-pane active" id="pill-justified-home-1" role="tabpanel">
                    <table class="table table-striped">
                        <tbody>
                            <tr>
                                <th scope="row">ID:</th>
                                <td>{{$customer->id}}</td>
                            </tr>
                            <tr>
                                <th scope="row">Name:</th>
                                <td>{{ $customer->name ?: "-" }}</td>
                            </tr>
                            <tr>
                                <th scope="row">Contact:</th>
                                <td>{{ $customer->contact ?: "-" }}</td>
                            </tr>
                            <tr>
                                <th scope="row">Alt Contact:</th>
                                <td>{{ $customer->alt_contact ?: "-" }}</td>
                            </tr>
                            <tr>
                                <th scope="row">Balance:</th>
                                <td>{{ $customer->balance ?: "-" }}</td>
                            </tr>
                            <tr>
                                <th scope="row">Created at</th>
                                <td>{{Carbon\Carbon::parse($customer->created_at)->format('d/m/Y H:i:s')}}</td>
                            </tr>
                            <tr>
                                <th scope="row">Updated at</th>
                                <td>{{Carbon\Carbon::parse($customer->updated_at)->format('d/m/Y H:i:s')}}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div class="tab-pane" id="pill-justified-profile-1" role="tabpanel">
                    <div class="table-responsive">
                        <table class="table dataTable">
                            <thead>
                                <th>Date</th>
                                <th>Branch</th>
                                <th>Receipt No.</th>
                                <th>Amount</th>
                            </thead>
                            <tbody>
                                @foreach($customer->credits as $credit)
                                    <tr>
                                        <td>{{ date('d-M-Y',strtotime($credit->date)) }}</td>
                                        <td>{{ $credit->branch?->name }}</td>
                                        <td>{{ $credit->receipt_no }}</td>
                                        <td>UGX {{ (($credit->amount)?number_format($credit->amount) : 0) }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="tab-pane" id="pill-justified-messages-1" role="tabpanel">
                    <div class="text-end">
                        <a class="btn btn-secondary mb-3" href="{{ url('payments/create') }}?customer_id={{ $customer->id }}">Add Payment</a>
                    </div>
                     <div class="table-responsive">
                        <table class="table dataTable">
                            <thead>
                                <th>Date</th>
                                <th>Amount</th>
                                <th>Balance</th>
                            </thead>
                            <tbody>
                                @foreach($customer->payments as $payment)
                                    <tr>
                                        <td>{{ date('d-M-Y',strtotime($payment->date)) }}</td>
                                        <td>{{ (($payment->amount)?number_format($payment->amount) : '0') }}</td>
                                        <td>{{ (($payment->amount)?number_format($payment->balance):'0') }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
                {{-- <div class="tab-pane" id="pill-justified-settings-1" role="tabpanel">
                    <div class="d-flex mt-2">
                        <div class="flex-shrink-0">
                            <i class="ri-checkbox-circle-fill text-success"></i>
                        </div>
                        <div class="flex-grow-1 ms-2">
                            For that very reason, I went on a quest and spoke to many different professional graphic designers and asked them what graphic design tips they live.
                        </div>
                    </div>
                    <div class="d-flex mt-2">
                        <div class="flex-shrink-0">
                            <i class="ri-checkbox-circle-fill text-success"></i>
                        </div>
                        <div class="flex-grow-1 ms-2">
                            After gathering lots of different opinions and graphic design basics, I came up with a list of 30 graphic design tips that you can start implementing.
                        </div>
                    </div>
                </div> --}}
            </div>
        </div>
        <div class="card-footer d-flex flex-column flex-md-row align-items-center justify-content-end">
            <a href="{{ route('customers.edit', compact('customer')) }}" class="btn btn-info text-nowrap me-1"><i class="fa fa-edit"></i> @lang('Edit')</a>
            <form action="{{ route('customers.destroy', compact('customer')) }}" method="POST" class="m-0 p-0">
                @csrf
                @method('DELETE')
                <button type="submit" class="btn btn-danger text-nowrap"><i class="fa fa-trash"></i> @lang('Delete')</button>
            </form>
        </div>
    </div>
</div>

@endsection
