@extends('layouts.app')
@section('content')
<div class="card">
	<form class="card-body">
		<div class="row">
			<div class="col-md-4">
				<label>Date</label>
				<input type="date" class="form-control" name="date">
			</div>
			<div class="col-md-4">
				<label>Customer</label>
				<select class="select2" name="customer_id">
					<option></option>
					@foreach($customers as $customer)
					<option value="{{ $customer->id }}">{{ $customer->name }}</option>
					@endforeach
				</select>
			</div>

			<div class="col-md-4">
				<label>Branch</label>
				<select class="select2" name="branch_id">
					<option></option>
					@foreach($branches as $branch)
					<option value="{{ $branch->id }}">{{ $branch->name }}</option>
					@endforeach
				</select>
				<div class="text-end">
					<button type="submit" class="btn btn-success">Search</button>
				</div>
			</div>
		</div>
	</form>
</div>
<div class="card">
	<div class="card-header">
		<h5 class="card-title">Discounts</h5>
	</div>
	<div class="card-body">
		<div class="table-responsive">
			<table class="table dataTable">
				<thead>
					<th>Date</th>
					<th>Branch</th>
					<th>Customer</th>
					<th>Inventory Item</th>
					<th>Rate</th>
					<th>Quantity</th>
					<th>Amount</th>
				</thead>
				<tbody>
					@foreach($discounts as $discount)
						<tr>
							<td>{{ date('d M, Y',strtotime($discount->date)) }}</td>
							<td>{{ $discount?->summary?->branch?->name }}</td>
							<td>{{ $discount?->customer?->name }}</td>
							<td>{{ $discount?->inventory?->name }}</td>
							<td>{{ $discount->discount_rate ? number_format($discount->discount_rate) : 0 }}</td>
							<td>{{ $discount->quantity ? number_format($discount->quantity) : 0 }}</td>
							<td>{{ $discount->total_discount ? number_format($discount->total_discount) : 0 }}</td>
						</tr>
					@endforeach
				</tbody>
			</table>
		</div>
	</div>
</div>
@endsection