@extends('layouts.app')
@section('breadcrumb')
<div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
    <h4 class="mb-sm-0">Daily Summaries</h4>
    <div class="page-title-right">
        <ol class="breadcrumb m-0">
            <li class="breadcrumb-item"><a href="{{ url('dashboard') }}">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="{{ url('summaries') }}">Daily Summaries</a></li>
            <li class="breadcrumb-item"><a href="javascript:void(0);">{{ $summary->branch?->name }}</a></li>
            <li class="breadcrumb-item"><a href="{{ url('summaries/modules/'.$summary->id) }}">{{ date('d M, Y',strtotime($summary->date)) }}</a></li>
            <li class="breadcrumb-item active">Intakes</li>
        </ol>
    </div>
</div>
@endsection
@section('content')
<div class="card">
    <div class="card-header">
        @include('layouts.summaries_menu')
    </div>
    <div class="card-body">
        <form action="{{ url('intakes') }}" method="POST">
            @csrf
            <input type="hidden" name="summary_id" value="{{ $summary->id }}">
            <div class="repeater">
                <table class="table">
                    <thead>
                        <th width="25%">Source</th>
                        <th width="25%">Inventory</th>
                        <th width="10%">Item Rate</th>
                        <th width="10%">Supplier Rate</th>
                        <th width="10%">Quantity</th>
                        <th width="10%">Total</th>
                        <th></th>
                    </thead>
                    <tbody data-repeater-list="items">
                        <tr data-repeater-item>
                            <td>
                                <select class="form-control form-select select2" name="source" required>
                                    <option></option>
                                    @foreach($sources as $source)
                                        <option value="{{ $source['id'] }}">{{ $source['name'] }}</option>
                                    @endforeach
                                </select>
                            </td>
                            <td>
                                <select class="form-control form-select inventory-select select2" name="inventory_id" required>
                                    <option></option>
                                    @foreach($inventories as $inventory)
                                        <option data-rate="{{ $inventory->rate }}" value="{{ $inventory->id }}">{{ $inventory->name }}</option>
                                    @endforeach
                                </select>
                            </td>
                            <td>
                                <input type="text" name="rate" class="form-control rate item_rate" required>
                            </td>
                            <td>
                                <input type="text" name="supplier_rate" class="form-control supplier_rate rate" required>
                            </td>
                            <td>
                                <input type="text" name="quantity" class="form-control quantity" required>
                            </td>
                            <td>
                                <input type="text" name="total" class="form-control total" disabled>
                            </td>
                            <td>
                                <button type="button" data-repeater-delete class="btn btn-danger">Delete</button>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <button type="button" data-repeater-create class="btn btn-primary">Add</button>
            </div>
            <div class="mt-4">
                <div class="row">
                    <div class="col-md-3 offset-md-9">
                        <div class="form-group">
                            <label for="grand-total">Grand Total:</label>
                            <input type="text" id="grand-total" class="form-control" disabled>
                        </div>
                    </div>
                </div>
            </div>
            <div class="d-flex flex-row align-items-center justify-content-between">
                <a href="javascript:void(0);" class="btn btn-info">Back</a>
                <button type="submit" class="btn btn-success">Save</button>
            </div>
        </form>
    </div>
</div>
@endsection

@section('customjs')
<script type="text/javascript">
    $(document).ready(function () {
                $('.select2').select2()
        var $repeater = $('.repeater').repeater({
            initEmpty: true,
            show: function () {
                $(this).slideDown();
                $('.select2-container').remove();
                $('.select2').select2()
                bindEvents($(this));
            },
            hide: function (deleteElement) {
                $(this).slideUp(deleteElement, function() {
                    $(this).remove();
                    calculateGrandTotal();
                });
            }
        });

        @if(old('items'))
            $repeater.setList(@json(old('items')));
        @elseif(sizeOf($intakes) > 0)
            $repeater.setList([
                @foreach ($intakes as $intake)
                    {
                        source: '{{ $intake->id }}',
                        inventory_id: '{{ $intake->inventory_id }}',
                        rate: '{{ $intake->rate }}',
                        quantity: '{{ $intake->quantity }}',
                        supplier_rate: '{{ $intake->supplier_rate }}',
                        total: '{{ $intake->amount }}',
                    },
                @endforeach
            ]);
        @endif

        calculateGrandTotal();

        // Bind the event functions to all initial repeater items
        $('.repeater [data-repeater-item]').each(function() {
            bindEvents($(this));
        });

        function bindEvents(item) {
            item.find('.inventory-select').on('change', function() {
                var selectedRate = $(this).find(':selected').data('rate') || 0;
                item.find('.rate').val(selectedRate).trigger('input');
            });

            item.find('.item_rate, .quantity').on('input', function() {
                var rate = parseFloat(item.find('.item_rate').val().replace(/,/g, '')) || 0;
                var quantity = parseFloat(item.find('.quantity').val()) || 0;
                var total = rate * quantity;
                item.find('.total').val(total.toLocaleString());
                calculateGrandTotal();
            });
        }

        function calculateGrandTotal() {
            var grandTotal = 0;
            $('.repeater .total').each(function() {
                var total = parseFloat($(this).val().replace(/,/g, '')) || 0;
                grandTotal += total;
            });
            $('#grand-total').val(grandTotal.toLocaleString());
        }
    });
</script>
@endsection
