@extends('personels.layout')

@section('personels.content')
    <div class="container">
        <div class="card">
            <div class="card-header d-flex flex-row align-items-center justify-content-between">
                <ol class="breadcrumb m-0 p-0">
                    <li class="breadcrumb-item"><a href="{{ implode('/', ['','personels']) }}"> Personels</a></li>
                    <li class="breadcrumb-item">@lang('Edit Personel') #{{$personel->id}}</li>
                </ol>
            </div>
            <div class="card-body">
                <form action="{{ route('personels.update', compact('personel')) }}" method="POST" class="m-0 p-0">
                    @method('PUT')
                    @csrf
                    <div class="card-body">
                        <div class="mb-3">
        <label for="name" class="form-label">Name:</label>
        <input type="text" name="name" id="name" class="form-control" value="{{@old('name', $personel->name)}}" required/>
        @if($errors->has('name'))
			<div class='error small text-danger'>{{$errors->first('name')}}</div>
		@endif
    </div>
    <div class="mb-3">
        <label for="station" class="form-label">Station:</label>
        <input type="text" name="station" id="station" class="form-control" value="{{@old('station', $personel->station)}}" required/>
        @if($errors->has('station'))
			<div class='error small text-danger'>{{$errors->first('station')}}</div>
		@endif
    </div>
    <div class="mb-3">
        <label for="status" class="form-label">Status:</label>
        <select name="status" id="status1" class="form-control form-select" required>
    <option value="">Select Status</option>
    @foreach(["Enabled" => "Enabled", "Disabled" => "Disabled"] as $value => $label )
        <option value="{{ $value }}" {{ @old('status', $personel->status) == $value ? "selected" : "" }}>{{ $label }}</option>
    @endforeach
</select>
        @if($errors->has('status'))
			<div class='error small text-danger'>{{$errors->first('status')}}</div>
		@endif
    </div>

                    </div>
                    <div class="card-footer">
                        <div class="d-flex flex-row align-items-center justify-content-between">
                            <a href="{{ route('personels.index', []) }}" class="btn btn-light">Cancel</a>
                            <button type="submit" class="btn btn-primary">@lang('Update Personel')</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
