@extends('layouts.app')
@section('content')
<div class="card">
	<form class="card-body">
		<div class="row">
			<div class="col-md-4">
				<label>Date</label>
				<input type="date" class="form-control filter-input" name="date">
			</div>
			<div class="col-md-4">
				<label>Personel</label>
				<select class="select2 filter-input" name="personel_id">
					<option></option>
					@foreach($personels as $personel)
					<option value="{{ $personel['id'] }}">{{ $personel['name'] }}</option>
					@endforeach
				</select>
			</div>

			<div class="col-md-4">
				<label>Branch</label>
				<select class="select2 filter-input" name="branch_id">
					<option></option>
					@foreach($branches as $branch)
					<option value="{{ $branch->id }}">{{ $branch->name }}</option>
					@endforeach
				</select>
				{{-- <div class="text-end">
					<button type="submit" class="btn btn-success">Search</button>
				</div> --}}
			</div>
		</div>
	</form>
</div>
<div class="card">
	<div class="card-header">
		<h5 class="card-title">Collections</h5>
	</div>
	<div class="card-body">
		<div class="table-responsive">
			 <table class="table table-bordered" id="collections-table">
	        <thead>
	            <tr>
	                {{-- <th>ID</th> --}}
	                <th>Date</th>
	                <th>Customer</th>
	                <th>Personel</th>
	                <th>Branch</th>
	                <th>Amount</th>
	                <th>Action</th>
	            </tr>
	        </thead>
	    </table>
		</div>
	</div>
</div>
@endsection
@section('customjs')
<script type="text/javascript">
$(document).ready(function(){
	let table = $('#collections-table').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: "{{ route('collections.index') }}",
            data: function (d) {
                d.date = $('input[name=date]').val();
                d.personel_id = $('select[name=personel_id]').val();
                d.branch_id = $('select[name=branch_id]').val();
            }
        },
        columns: [
            // { data: 'id', name: 'id' },
            { data: 'date', name: 'date' },
            { data: 'customer_name', name: 'customer_name' },
            { data: 'personel_name', name: 'personel_name' },
            { data: 'branch_name', name: 'branch_name' },
            { data: 'amount', name: 'amount' },
            { data: 'action', name: 'action', orderable: false, searchable: false }
        ]
    });

    // // Reload DataTable on Filter Submit
    // $('#filter-form').on('submit', function (e) {
    //     e.preventDefault();
    //     table.draw();
    // });
    $('.filter-input').on('change', function () {
        table.ajax.reload();  // Correct way to reload without reinitializing
    });
})
</script>

@endsection