@extends('customers.layout')

@section('customers.content')
    <div class="container">
        <div class="card">
            <div class="card-header d-flex flex-row align-items-center justify-content-between">
                <ol class="breadcrumb m-0 p-0">
                    <li class="breadcrumb-item"><a href="{{ implode('/', ['','customers']) }}"> Customers</a></li>
                    <li class="breadcrumb-item">@lang('Edit Customer') #{{$customer->id}}</li>
                </ol>
            </div>
            <div class="card-body">
                <form action="{{ route('customers.update', compact('customer')) }}" method="POST" class="m-0 p-0">
                    @method('PUT')
                    @csrf
                    <div class="card-body">
                        <div class="mb-3">
        <label for="name" class="form-label">Name:</label>
        <input type="text" name="name" id="name" class="form-control" value="{{@old('name', $customer->name)}}" required/>
        @if($errors->has('name'))
			<div class='error small text-danger'>{{$errors->first('name')}}</div>
		@endif
    </div>
    <div class="mb-3">
        <label for="contact" class="form-label">Contact:</label>
        <input type="text" name="contact" id="contact" class="form-control" value="{{@old('contact', $customer->contact)}}" required/>
        @if($errors->has('contact'))
			<div class='error small text-danger'>{{$errors->first('contact')}}</div>
		@endif
    </div>
    <div class="mb-3">
        <label for="alt_contact" class="form-label">Alt Contact:</label>
        <input type="text" name="alt_contact" id="alt_contact" class="form-control" value="{{@old('alt_contact', $customer->alt_contact)}}" />
        @if($errors->has('alt_contact'))
			<div class='error small text-danger'>{{$errors->first('alt_contact')}}</div>
		@endif
    </div>
    <div class="mb-3">
        <label for="balance" class="form-label">Balance:</label>
        <input type="text" name="balance" id="balance" class="form-control"/>
        @if($errors->has('balance'))
			<div class='error small text-danger'>{{$errors->first('balance')}}</div>
		@endif
    </div>

                    </div>
                    <div class="card-footer">
                        <div class="d-flex flex-row align-items-center justify-content-between">
                            <a href="{{ route('customers.index', []) }}" class="btn btn-light">Cancel</a>
                            <button type="submit" class="btn btn-primary">@lang('Update Customer')</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
