@extends('customers.layout')

@section('customers.content')
<div class="">
    <div class="card">
        <div class="card-body">
            <!-- Nav tabs -->
            <ul class="nav nav-pills nav-justified mb-3" role="tablist">
                <li class="nav-item waves-effect waves-light">
                    <a class="nav-link active" data-bs-toggle="tab" href="#customer-details" role="tab">
                        <i class="ri-user-line align-middle me-1"></i> Details
                    </a>
                </li>
                <li class="nav-item waves-effect waves-light">
                    <a class="nav-link" data-bs-toggle="tab" href="#collections" role="tab">
                        <i class="ri-archive-drawer-line align-middle me-1"></i> Collections
                    </a>
                </li>
                <li class="nav-item waves-effect waves-light">
                    <a class="nav-link" data-bs-toggle="tab" href="#credits" role="tab">
                        <i class="ri-wallet-3-line align-middle me-1"></i> Credits
                    </a>
                </li>
                <li class="nav-item waves-effect waves-light">
                    <a class="nav-link" data-bs-toggle="tab" href="#payments" role="tab">
                        <i class="ri-money-dollar-circle-line align-middle me-1"></i> Payments
                    </a>
                </li>
                <li class="nav-item waves-effect waves-light">
                    <a class="nav-link" data-bs-toggle="tab" href="#suspense" role="tab">
                        <i class="ri-exchange-funds-line align-middle me-1"></i> Suspense
                    </a>
                </li>
            </ul>

            <!-- Tab panes -->
            <div class="tab-content">
                <!-- Customer Details Tab -->
                <div class="tab-pane active" id="customer-details" role="tabpanel">
                    <table class="table table-striped table-hover">
                        <tbody>
                            <tr>
                                <th width="30%">ID:</th>
                                <td>{{ $customer->id }}</td>
                            </tr>
                            <tr>
                                <th>Name:</th>
                                <td>{{ $customer->name ?: '-' }}</td>
                            </tr>
                            <tr>
                                <th>Contact:</th>
                                <td>{{ $customer->contact ?: '-' }}</td>
                            </tr>
                            <tr>
                                <th>Alt Contact:</th>
                                <td>{{ $customer->alt_contact ?: '-' }}</td>
                            </tr>
                            <tr>
                                <th>Account Balance:</th>
                                <td>UGX {{ number_format($customer->balance) }}</td>
                            </tr>
                            <tr>
                                <th>Suspense Balance:</th>
                                <td>UGX {{ number_format($customer->suspense_account_balance) }}</td>
                            </tr>
                            <tr>
                                <th>Created At:</th>
                                <td>{{ $customer->created_at->format('d/m/Y H:i') }}</td>
                            </tr>
                            <tr>
                                <th>Last Updated:</th>
                                <td>{{ $customer->updated_at->format('d/m/Y H:i') }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>

                <!-- Collections Tab -->
                <div class="tab-pane" id="collections" role="tabpanel">
                    <div class="table-responsive">
                        <table class="table dataTable table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>Date</th>
                                    <th>Branch</th>
                                    <th>Reason</th>
                                    <th>Amount</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($customer->collections as $collection)
                                <tr>
                                    <td>{{ date('d-M-Y',strtotime($collection->date)) }}</td>
                                    <td>{{ $collection->branch?->name ?? '-' }}</td>
                                    <td>{{ $collection->reason }}</td>
                                    <td>UGX {{ number_format($collection->amount) }}</td>
                                    <td>
                                        @if($collection->summary?->status == "Open" || auth()->user()->can('edit collections'))
                                        <div class="btn-group">
                                            <a href="{{ route('collections.edit', $collection) }}" class="btn btn-sm btn-outline-primary">
                                                <i class="ri-edit-line"></i>
                                            </a>
                                            @if($collection->summary?->status == "Open" || auth()->user()->can('delete collections'))
                                            <form method="POST" action="{{ route('collections.destroy', $collection) }}">
                                                @csrf @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-outline-danger">
                                                    <i class="ri-delete-bin-line"></i>
                                                </button>
                                            </form>
                                            @endif
                                        </div>
                                        @endif
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Credits Tab -->
                <div class="tab-pane" id="credits" role="tabpanel">
                    <div class="table-responsive">
                        <table class="table dataTable table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>Date</th>
                                    <th>Branch</th>
                                    <th>Receipt No</th>
                                    <th>Amount</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($customer->credits as $credit)
                                <tr>
                                    <td>{{ date('d-M-Y',strtotime($credit->date)) }}</td>
                                    <td>{{ $credit->branch?->name ?? '-' }}</td>
                                    <td>{{ $credit->receipt_no }}</td>
                                    <td>UGX {{ number_format($credit->amount) }}</td>
                                    <td>
                                        @if($credit->summary?->status == "Open" || auth()->user()->can('edit credits'))
                                        <a href="{{ route('credits.edit', $credit) }}" class="btn btn-sm btn-outline-primary">
                                            <i class="ri-edit-line"></i>
                                        </a>
                                        @endif
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Payments Tab -->
                <div class="tab-pane" id="payments" role="tabpanel">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h5 class="mb-0">Payment History</h5>
                        @can('create payments')
                        <a href="{{ route('payments.create', ['customer_id' => $customer->id]) }}" 
                           class="btn btn-primary btn-sm">
                            <i class="ri-add-line align-middle me-1"></i> New Payment
                        </a>
                        @endcan
                    </div>
                    <div class="table-responsive">
                        <table class="table dataTable table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>Date</th>
                                    <th>Amount</th>
                                    <th>Balance After</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($customer->payments as $payment)
                                <tr>
                                    <td>{{ date('d M Y',strtotime($payment->date)) }}</td>
                                    <td>UGX {{ number_format($payment->amount) }}</td>
                                    <td>UGX {{ number_format($payment->balance) }}</td>
                                    <td>
                                        @can('edit payments')
                                        <a href="{{ route('payments.edit', $payment) }}" 
                                           class="btn btn-sm btn-outline-primary">
                                            <i class="ri-edit-line"></i>
                                        </a>
                                        @endcan
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Suspense Tab -->
                <div class="tab-pane" id="suspense" role="tabpanel">
                    <div class="table-responsive">
                        <table class="table dataTable table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>Date</th>
                                    <th>Type</th>
                                    <th>Amount</th>
                                    <th>Linked Transaction</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($customer?->suspenseTransactions as $transaction)
                                <tr>
                                    <td>{{ date('d-M-Y',strtotime($transaction->created_at)) }}</td>
                                    <td>
                                        <span class="badge bg-{{ $transaction->type === 'credit' ? 'success' : 'danger' }}">
                                            {{ ucfirst($transaction->type) }}
                                        </span>
                                    </td>
                                    <td>UGX {{ number_format($transaction->amount) }}</td>
                                    <td>
                                        @if($transaction->transactionable)
                                        <a href="{{ route(strtolower(class_basename($transaction->transactionable)) . 's.show', $transaction->transactionable) }}" 
                                           class="text-primary">
                                            {{ class_basename($transaction->transactionable) }} #{{ $transaction->transactionable->id }}
                                        </a>
                                        @else
                                        -
                                        @endif
                                    </td>
                                    <td>
                                        <button class="btn btn-sm btn-outline-secondary" 
                                                data-bs-toggle="tooltip" 
                                                title="Transaction Hash: {{ $transaction->id }}">
                                            <i class="ri-information-line"></i>
                                        </button>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="card-footer d-flex gap-2 justify-content-end">

            <button type="button" class="btn btn-outline-warning" data-bs-toggle="modal" data-bs-target="#transferToSuspenseModal">
                <i class="ri-exchange-funds-line align-middle me-1"></i> Suspense Account Transfer
            </button>

            <a href="{{ route('customers.edit', $customer) }}" 
               class="btn btn-outline-primary">
               <i class="ri-edit-line align-middle me-1"></i> Edit Profile
            </a>

            <form method="POST" action="{{ route('customers.destroy', $customer) }}">
                @csrf @method('DELETE')
                <button type="submit" class="btn btn-outline-danger"
                        onclick="return confirm('Are you sure you want to delete this customer?')">
                    <i class="ri-delete-bin-line align-middle me-1"></i> Delete Account
                </button>
            </form>
        </div>
    </div>
</div>
<div class="modal fade" id="transferToSuspenseModal" tabindex="-1" aria-labelledby="transferToSuspenseModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <form class="modal-content" method="POST" action="{{ url('suspense-account-transfers', $customer) }}">
            @csrf
            {{-- <input type="hidden" name="customer_id" value="{{ $customer->id }}"> --}}
            <div class="modal-header">
                <h5 class="modal-title" id="transferToSuspenseModalLabel">Confirm Transfer</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label>Type</label>
                    <select class="form-control form-select" name="type">
                        <option value="In">In</option>
                        <option value="Out">Out</option>
                    </select>
                </div>
                <div class="form-group mt-3">
                    <label>Amount</label>
                    <input type="text" name="amount" class="form-control">
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                
                    
                    <button type="submit" class="btn btn-warning">Confirm Transfer</button>
            </div>
        </form>
    </div>
</div>

@section('customjs')
<script>
   {{--  $(document).ready(function() {
        $('.dataTable').DataTable({
            order: [[0, 'desc']],
            pageLength: 10,
            responsive: true,
            dom: '<"row"<"col-sm-6"l><"col-sm-6"f>>rtip'
        });
        
        // Initialize tooltips
        const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]')
        const tooltipList = [...tooltipTriggerList].map(tooltipTriggerEl => new bootstrap.Tooltip(tooltipTriggerEl))
    }); --}}
</script>
@endsection

@endsection