@extends('layouts.app')
@section('breadcrumb')
<div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
    <h4 class="mb-sm-0">Daily Summaries</h4>
    <div class="page-title-right">
        <ol class="breadcrumb m-0">
            <li class="breadcrumb-item"><a href="{{ url('dashboard') }}">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="{{ url('disbursements') }}">Disbursements</a></li>
            <li class="breadcrumb-item active">Create</li>
        </ol>
    </div>
</div>
@endsection
@section('content')
<div class="card">
    <div class="card-header">
        
    </div>
    <div class="card-body">
        <form action="{{ url('disbursements') }}" method="POST">
            @csrf
            <input type="hidden" name="date" value="{{ $date }}">
            
            <div class="repeater">
                <table class="table">
                    <thead>
                        <th>Personel</th>
                        <th>Supplier</th>
                        <th>Amount</th>
                    </thead>
                    <tbody data-repeater-list="items">
                        <tr data-repeater-item>
                            <td width="30%">
                                <select class="form-control form-select select2 personel_id" name="personel_id" required>
                                        <option value="">Select Personel</option>
                                        @foreach($personels as $personel)
                                            <option value="{{ $personel->id }}">{{ $personel->name }}</option>
                                        @endforeach
                                    </select>
                                    <textarea name="reason" class="form-control reason" placeholder="Reason for disbursement"></textarea>
                            </td>
                            <td width="30%">
                                <select class="form-control form-select select2 supplier_id" name="supplier_id" required>
                                        <option value="">Select Supplier</option>
                                        @foreach($suppliers as $supplier)
                                            <option value="{{ $supplier->id }}">{{ $supplier->name }}</option>
                                        @endforeach
                                    </select>
                            </td>
                            <td>
                                <input type="number" name="amount" class="form-control amount" required>
                                <input type="hidden" name="status">
                                <div class="text-end">
                                    <button type="button" data-repeater-delete class="btn btn-danger">Delete</button>
                                </div>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <button type="button" data-repeater-create class="btn btn-primary">Add</button>
            </div>
            <div class="mt-4">
                <div class="row">
                    <div class="col-md-3 offset-md-9">
                        <div class="form-group">
                            <label for="grand-total">Grand Total:</label>
                            <input type="text" id="grand-total" class="form-control" disabled>
                        </div>
                    </div>
                </div>
            </div>
            <div class="d-flex flex-row align-items-center justify-content-between">
                {{-- <a href="{{ url('transfers/create') }}?summary_id={{ $summary->id }}" class="btn btn-info">Cancel</a> --}}
                <button type="submit" class="btn btn-success">Save</button>
            </div>
        </form>
    </div>
</div>
@endsection

@section('customjs')
<script type="text/javascript">
    $(document).ready(function () {
                $('.select2').select2()
        var $repeater = $('.repeater').repeater({
            initEmpty: true,
            show: function () {
                $(this).slideDown();
                $('.select2-container').remove();
                $('.select2').select2()
                bindEvents($(this));
            },
            hide: function (deleteElement) {
                $(this).slideUp(deleteElement, function() {
                    $(this).remove();
                    calculateGrandTotal();
                });
            }
        });

        @if(old('items'))
            $repeater.setList(@json(old('items')));
        @elseif($disbursements->count() > 0)
            $repeater.setList([
                @foreach ($disbursements as $disbursement)
                    {
                        personel_id: '{{ $disbursement->personel_id }}',
                        supplier_id: '{{ $disbursement->supplier_id }}',
                        amount: '{{ $disbursement->amount }}',
                        reason: '{{ $disbursement->reason }}',
                        status: '{{ $disbursement->status }}'
                    },
                @endforeach
            ]);
        @endif

        calculateGrandTotal();

        // Bind the event functions to all initial repeater items
        $('.repeater [data-repeater-item]').each(function() {
            bindEvents($(this));
            $(this).find('.amount').attr('disabled',true)
            $(this).find('.supplier_id').attr('disabled',true)
            $(this).find('.personel_id').attr('disabled',true)
            $(this).find('.reason').attr('disabled',true)
        });

        function bindEvents(item) {
            item.find('.inventory-select').on('change', function() {
                var selectedRate = $(this).find(':selected').data('rate') || 0;
                item.find('.amount').val(selectedRate).trigger('input');
            });

            item.find('.amount').on('input', function() {
                var amount = parseFloat(item.find('.amount').val()) || 0;
                // var quantity = parseFloat(item.find('.quantity').val()) || 0;
                // var total = rate * quantity;
                // item.find('.total').val(total);
                calculateGrandTotal();
            });
        }

        function calculateGrandTotal() {
            var grandTotal = 0;
            $('.repeater .amount').each(function() {
                var total = parseFloat($(this).val()) || 0;
                grandTotal += total;
            });
            $('#grand-total').val(grandTotal.toLocaleString());
        }
    });
</script>
@endsection