@extends('layouts.app')
@section('content')
<div class="card">
    <form class="card-body" id="filter-form">
        <div class="row">
            <div class="col-md-4">
                <label>Date</label>
                <input type="date" class="form-control" name="date">
            </div>
            <div class="col-md-4">
                <label>Customer</label>
                <select class="select2" name="customer_id">
                    <option></option>
                    @foreach($customers as $customer)
                        <option value="{{ $customer->id }}">{{ $customer->name }}</option>
                    @endforeach
                </select>
            </div>

            <div class="col-md-4">
                <label>Branch</label>
                <select class="select2" name="branch_id">
                    <option></option>
                    @foreach($branches as $branch)
                        <option value="{{ $branch->id }}">{{ $branch->name }}</option>
                    @endforeach
                </select>
                <div class="text-end">
                    <button type="submit" class="btn btn-success">Search</button>
                </div>
            </div>
        </div>
    </form>
</div>

<div class="card">
    <div class="card-header">
        <h5 class="card-title">Discounts</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table dataTable table-striped" id="discounts-table">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Branch</th>
                        <th>Customer</th>
                        <th>Inventory Item</th>
                        <th>Rate</th>
                        <th>Quantity</th>
                        <th>Amount</th>
                    </tr>
                </thead>
                <tbody>
                    <!-- Data will be populated here via AJAX -->
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection

@section('customjs')
<script>
$(document).ready(function() {
    // Initialize Select2 for dropdowns
    $('.select2').select2();

    // Initialize DataTable with server-side processing
    let table = $('#discounts-table').DataTable({
        processing: true,
        serverSide: true,
        ajax: {
            url: "{{ route('discounts.index') }}",
            data: function(d) {
                d.date = $('input[name="date"]').val();
                d.customer_id = $('select[name="customer_id"]').val();
                d.branch_id = $('select[name="branch_id"]').val();
            }
        },
        columns: [
            { data: 'date', name: 'date' },
            { data: 'branch_name', name: 'branch_name' },
            { data: 'customer_name', name: 'customer_name' },
            { data: 'inventory_name', name: 'inventory_name' },
            { data: 'discount_rate', name: 'discount_rate' },
            { data: 'quantity', name: 'quantity' },
            { data: 'total_discount', name: 'total_discount' }
        ]
    });

    // Trigger table reload when the form is submitted
    $('#filter-form').on('submit', function(e) {
        e.preventDefault();
        table.ajax.reload(); // Reload the DataTable with new filter values
    });
});
</script>
@endsection
