@extends('layouts.app')
@section('content')
<div class="col-md-6 mx-auto">
	<form class="card" action="{{ url('intakes/'.$intake->id) }}" method="POST">
		@csrf
		@method("PUT")
		<div class="card-header">
			<h4>Edit Intake</h4>
		</div>
		<div class="card-body">
			<div class="mb-3">
				<label>Source</label>
				<select class="form-control form-select select2" name="source" required>
                    <option></option>
                     @foreach($sources as $source)
                         <option value="{{ $source['id'] }}" {{ ($source['id'] == $selected)?'selected':''  }}>{{ $source['name'] }}</option>
                     @endforeach
                 </select>
			</div>
			<div class="mb-3">
				<label>Inventory</label>
				<select class="form-control form-select inventory-select select2" name="inventory_id" required>
                    <option></option>
                    @foreach($inventories as $inventory)
                        <option data-rate="{{ $inventory->rate }}" value="{{ $inventory->id }}" {{ ($inventory->id == $intake->inventory_id) ? 'selected':'' }}>{{ $inventory->name }}</option>
                    @endforeach
                </select>
			</div>
			<div class="mb-3">
				<label>Item Rate</label>
				<input type="text" name="rate" class="form-control rate item_rate" value="{{ $intake->rate }}" required>
			</div>

			<div class="mb-3">
				<label>Supplier Rate</label>
				<input type="text" name="supplier_rate" class="form-control supplier_rate rate" value="{{ $intake->supplier_rate }}" required>
			</div>
			<div class="mb-3">
				<label>Quantity</label>
				<input type="text" name="quantity" class="form-control quantity" value="{{ $intake->quantity }}" required>
			</div>
		</div>
		<div class="card-footer text-end">
			<button type="submit" class="btn btn-primary">Update</button>
		</div>
	</form>
</div>
@endsection