@extends('layouts.app')
@section('breadcrumb')
<div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
    <h4 class="mb-sm-0">Daily Summaries</h4>
    <div class="page-title-right">
        <ol class="breadcrumb m-0">
            <li class="breadcrumb-item"><a href="{{ url('dashboard') }}">Dashboard</a></li>
          {{--   <li class="breadcrumb-item"><a href="{{ url('summaries') }}">Daily Summaries</a></li>
            <li class="breadcrumb-item"><a href="javascript:void(0);">{{ $summary->branch?->name }}</a></li>
            <li class="breadcrumb-item"><a href="{{ url('summaries/modules/'.$summary->id) }}">{{ date('d M, Y',strtotime($summary->date)) }}</a></li> --}}
            <li class="breadcrumb-item active">Purchases</li>
        </ol>
    </div>
</div>
@endsection
@section('content')
<div class="card">
    <div class="card-header">
        {{-- @include('layouts.summaries_menu') --}}
    </div>
    <div class="card-body">
        <form action="{{ url('purchases') }}" method="POST">
            @csrf
            {{-- <input type="hidden" name="summary_id" value="{{ $summary->id }}"> --}}
            <div  class="row">
            	<div class="col-md-4">
            		<label>Supplier</label>
            		<select class="select2" name="supplier">
            			<option selected disabled></option>
            			@foreach($suppliers as $supplier)
            				<option value="{{ $supplier->id }}">{{ $supplier->name }}</option>
            			@endforeach
            		</select>
            	</div>
            	<div class="col-md-4">
            		<label>Purchase Dates</label>
            		<input type="date" class="form-control" name="date" placeholder="Purchase Date">
            	</div>
            	<div class="col-md-4">
            		<label>Reference</label>
            		<input type="text" class="form-control" name="reference" placeholder="Purchase Reference">
            	</div>
            </div>
            <div class="repeater">
                <table class="table">
                    <thead>
                        <th width="40%">Inventory Item</th>
                        <th>Rate</th>
                        <th>Quantity</th>
                        <th>Amount</th>
                    </thead>
                    <tbody data-repeater-list="items">
                        <tr data-repeater-item>
                            <td>
                                <select class="form-control form-select select2" name="item_id" required>
                                        <option></option>
                                        @foreach($items as $item)
                                            <option value="{{ $item->id }}">{{ $item->name }}</option>
                                        @endforeach
                                    </select>
                            </td>
                            <td>
                            	<input type="text" name="rate" class="form-control" placeholder="Rate" required>
                            </td>
                            <td>
                            	<input type="text" name="quantity" class="form-control" placeholder="Quantity" required>
                            </td>
                            <td>
                                {{-- <input type="number" name="amount" class="form-control amount" required> --}}
                                <div class="text-end">
                                    <button type="button" data-repeater-delete class="btn btn-danger">Delete</button>
                                </div>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <button type="button" data-repeater-create class="btn btn-primary">Add</button>
            </div>
            <div class="mt-4">
                <div class="row">
                    <div class="col-md-3 offset-md-9">
                        <div class="form-group">
                            <label for="grand-total">Grand Total:</label>
                            <input type="text" id="grand-total" class="form-control" disabled>
                        </div>
                    </div>
                </div>
            </div>
            <div class="d-flex flex-row align-items-center justify-content-between">
                {{-- <a href="{{ url('transfers/create') }}?summary_id={{ $summary->id }}" class="btn btn-info">Cancel</a> --}}
                <button type="submit" class="btn btn-success">Save</button>
            </div>
        </form>
    </div>
</div>
@endsection

@section('customjs')
<script type="text/javascript">
   $(document).ready(function () {
    $('.select2').select2();

    var $repeater = $('.repeater').repeater({
        initEmpty: false,
        show: function () {
            $(this).slideDown();
            $('.select2-container').remove();
            $('.select2').select2();
            bindEvents($(this)); // Bind events on new row
        },
        hide: function (deleteElement) {
            $(this).slideUp(deleteElement, function() {
                $(this).remove();
                calculateGrandTotal();
            });
        }
    });

    @if(old('items'))
        $repeater.setList(@json(old('items')));
    @endif

    function formatNumber(input) {
        return input.replace(/\D/g, "").replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    }

    function parseNumber(input) {
        return parseFloat(input.replace(/,/g, '')) || 0;
    }

    function calculateTotal(row) {
        let rate = parseNumber(row.find('input[name="rate"]').val());
        let quantity = parseNumber(row.find('input[name="quantity"]').val());
        let amount = rate * quantity;

        row.find('input[name="amount"]').val(amount.toFixed(2));
        calculateGrandTotal();
    }

    function calculateGrandTotal() {
        let total = 0;
        $('.amount').each(function () {
            total += parseNumber($(this).val());
        });
        $('#grand-total').val(total.toLocaleString('en-US', { minimumFractionDigits: 2 }));
    }

    function bindEvents(row) {
        row.find('input[name="rate"], input[name="quantity"]').on('keyup', function () {
            let formatted = formatNumber($(this).val());
            $(this).val(formatted);
            calculateTotal(row);
        });
    }

    $('.repeater tbody tr').each(function () {
        bindEvents($(this));
    });
});

</script>
@endsection