@extends('layouts.app')
@section('content')
<div class="card">
	<div class="card-header d-flex flex-column flex-md-row align-items-md-center justify-content-between">
		<h5>Purchases</h5>
		<a href="{{ url('purchases/create') }}" class="btn btn-primary">New Purchase</a>
	</div>
	<div class="card-body">
		<table class="table-responsive">
			<table class="table dataTable">
				<thead>
					<th>Purchase No</th>
					<th>Supplier</th>
					<th>Date</th>
					<th>Action(s)</th>
				</thead>
				<tbody>
					@foreach($purchases as $purchase)
						<tr>
							<td>{{ $purchase->purchase_no }}</td>
							<td>{{ $purchase->supplier?->name }}</td>
							<td>{{ $purchase->date ? date('d-M-Y',strtotime($purchase->date)) : '-' }}</td>
							<td>
								<a href="{{ url('purchases/'.$purchase->id) }}" class="btn btn-primary btn-sm">Show</a>
							</td>
						</tr>
					@endforeach
				</tbody>
			</table>
		</table>
	</div>
</div>
@endsection