@extends('layouts.app')
@section('content')
<div class="card">
	<div class="card-header flex-column flex-md-row align-items-md-center justify-content-between">
		<h5>Purchase Details</h5>

		{{-- <span>{{ $purchase->status }}</span> --}}
	</div>
	<div class="card-body">
		<div class="row">
			<div class="mb-3 col-md-4">
				<label>Supplier</label>
				<div>
					{{ $purchase->supplier?->name }}
				</div>
			</div>
			<div class="mb-3 col-md-4">
				<label>Purchase Date</label>
				<div>
					{{ date('d-M-Y',strtotime($purchase->date)) }}
				</div>
			</div>
			<div class="mb-3 col-md-4">
				<label>Reference</label>
				<div>
					{{ $purchase->reference }}
				</div>
			</div>
		</div>
		<div class="table-responsive">
			<table class="table table-striped">
				<thead>
					<th>Inventory Item</th>
					<th>Rate</th>
					<th>Quantity</th>
					<th>Total</th>
				</thead>
				<tbody>
					@foreach($purchase->items as $item)
						<tr class="">
							<td>{{ $item->Inventory?->name }}</td>
							<td>{{ ($item->rate)? (number_format($item->rate,2)) : '-' }}</td>
							<td>{{ ($item->quantity)? (number_format($item->quantity,2)) : '-' }}</td>
							<td>{{ ($item->quantity)? (number_format($item->quantity * $item->rate,2)) : '-' }}</td>
						</tr>
					@endforeach
				</tbody>
			</table>
		</div>
	</div>
	<div class="card-footer">
		@if($purchase->status == "Draft")
		<a href="{{ url('approve_purchase/'.$purchase->id) }}" class="btn btn-danger">Approve</a>
		@endif
	</div>
</div>
@endsection