@extends('layouts.app')
@section('breadcrumb')
<div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
	<h4 class="mb-sm-0">Daily Summaries</h4>
	<div class="page-title-right">
		<ol class="breadcrumb m-0">
			<li class="breadcrumb-item"><a href="{{ url('dashboard') }}">Dashboard</a></li>
			<li class="breadcrumb-item"><a href="{{ url('summaries') }}">Daily Summaries</a></li>
			<li class="breadcrumb-item"><a href="javascript:void(0);">{{ $summary->branch?->name }}</a></li>
			<li class="breadcrumb-item"><a href="{{ url('summaries/modules/'.$summary->id) }}">{{ date('d M, Y',strtotime($summary->date)) }}</a></li>
			<li class="breadcrumb-item active">Modules</li>
		</ol>
	</div>
</div>
@endsection
@section('content')
<div class="row">
	@can('create collections')
	<div class="col-md-6">
		<a href="{{ url('collections/create') }}?summary_id={{ $summary->id }}" class="card">
			<div class="card-body">
				<h4>Collections</h4>
				<h6>{{ number_format($summary->collections_sum_amount) }}</h6>
			</div>
		</a>
	</div>
	@endcan
	@can('create credits')
	<div class="col-md-6">
		<a href="{{ url('credits/create') }}?summary_id={{ $summary->id }}" class="card">
			<div class="card-body">
				<h4>Credits</h4>
				<h6>{{ number_format($summary->credits_sum_amount) }}</h6>
			</div>
		</a>
	</div>
	@endcan
	@can('create discounts')
	<div class="col-md-6">
		<a href="{{ url('discounts/create') }}?summary_id={{ $summary->id }}" class="card">
			<div class="card-body">
				<h4>Discounts</h4>
				<h6>{{ number_format($summary->summary_discounts_sum_total_discount) }}</h6>
			</div>
		</a>
	</div>
	@endcan
	@can('create intakes')
	<div class="col-md-6">
		<a href="{{ url('intakes/create') }}?summary_id={{ $summary->id }}" class="card">
			<div class="card-body">
				<h4>Intakes</h4>
				<h6>{{ number_format($summary->intakes_sum_amount) }}</h6>
			</div>
		</a>
	</div>
	@endcan
	@can('create transfers')
	<div class="col-md-6">
		<a href="{{ url('transfers/create') }}?summary_id={{ $summary->id }}" class="card">
			<div class="card-body">
				<h4>Outward Transfers</h4>
				<h6>{{ number_format($summary->summary_transfers_sum_amount) }}</h6>
			</div>
		</a>
	</div>
	@endcan
	@can('create expenses')
	<div class="col-md-6">
		<a href="{{ url('expenses/create') }}?summary_id={{ $summary->id }}" class="card">
			<div class="card-body">
				<h4>Expenses</h4>
				<h6>{{ number_format($summary->summary_expenses_sum_amount) }}</h6>
			</div>
		</a>
	</div>
	@endcan
	@can('create recoveries')
	<div class="col-md-6">
		<a href="{{ url('recoveries/create') }}?summary_id={{ $summary->id }}" class="card">
			<div class="card-body">
				<h4>Recoveries</h4>
				<h6>{{ number_format($summary->recoveries_sum_amount) }}</h6>
			</div>
		</a>
	</div>
	@endcan
	@can('create profits')
	<div class="col-md-6">
		<a href="{{ url('profits/create') }}?summary_id={{ $summary->id }}" class="card">
			<div class="card-body">
				<h4>Profits</h4>
				<h6>{{ number_format($summary->profits_sum_amount) }}</h6>
			</div>
		</a>
	</div>
	@endcan
	@can('show summaries')
	<div class="col-md-6">
		<a href="{{ url('summaries/summary/'.$summary->id) }}" class="card">
			<div class="card-body">
				<h4>Summary</h4>
			</div>
		</a>
	</div>
	@endcan
	@can('delete summaries')
		<div class="col-md-6">
			<form action="{{ route('summaries.destroy', compact('summary')) }}" method="POST" class="card m-0 p-0">
                @csrf
                @method('DELETE')
                <button type="submit" class="card-body text-nowrap"><i class="fa fa-trash"></i> @lang('Delete')</button>
            </form>
		</div>
	@endcan
</div>
@endsection