@extends('layouts.app')
@section('content')
<div class="card">
	<div class="card-header">
		<h5 class="card-title">Business Summaries</h5>
	</div>
	<div class="card-header">
		<div class="table-responsive">
			<table class="table dataTable">
				<thead>
					<th>Date</th>
					<th>Collections</th>
					<th>Withdraws</th>
					<th>Balance</th>
					<th></th>
				</thead>
				<tbody>
					@foreach($summaries as $summary)
					<tr>
						<td>{{ date('d M Y',strtotime($summary->date)) }}</td>
						<td>{{ $summary->collections?number_format($summary->collections):0 }}</td>
						<td>{{ $summary->withdraws?number_format($summary->withdraws):0 }}</td>
						<td>{{ $summary->balance?number_format($summary->balance):0 }}</td>
						<td>
							<a href="{{ url('withdraws/'.$summary->id) }}" class="btn btn-primary btn-sm">Show</a>
						</td>
					</tr>
					@endforeach
				</tbody>
			</table>
		</div>
	</div>
</div>
@endsection