@extends('layouts.app')
@section('content')
<div class="card">
	<div class="card-header">
		<h5>Summary</h5>
	</div>
	<div class="card-body">
		<div class="row">
			<div class="col-md-3 mb-3">
				<label>Date</label>
				<div class="">{{ date('d M, Y',strtotime($summary->date)) }}</div>
			</div>
			<div class="col-md-3 mb-3">
				<label>Collections</label>
				<div>
					{{ $summary->collections ? number_format($summary->collections) : 0 }}
				</div>
			</div>
			<div class="col-md-3 mb-3">
				<label>Withdraws</label>
				<div>
					{{ $summary->collections ? number_format($summary->withdrawals) : 0 }}
				</div>
			</div>
			<div class="col-md-3 mb-3">
				<label>Balance</label>
				<div>
					{{ $summary->collections ? number_format($summary->balance) : 0 }}
				</div>
			</div>
		</div>
	</div>
</div>
<form class="card" method="POST" action="{{ url('withdraws') }}">
	@csrf
	<input type="hidden" name="summary_id" value="{{ $summary->id }}">
	<div class="card-header">
		<h5>Add Withdraw</h5>
	</div>
	<div class="card-body">
		<div class="row">
			<div class="col-md-6">
				<label>Person</label>
				<input type="text" class="form-control" name="person">
				<textarea placeholder="Narration" class="form-control" name="narration"></textarea>
			</div>
			<div class="col-md-6">
				<label>Amount</label>
				<input type="text" class="form-control" name="amount">
				<div class="text-end">
					<button type="text" class="btn btn-primary">Add</button>
				</div>
			</div>
		</div>
	</div>
</form>
<div class="card">
	<div class="card-header">
		<h5 class="card-title">Withdraws</h5>
	</div>
	<div class="card-body">
		<div class="table-responsive">
			<table class="table dataTable">
				<thead>
					<th>Person</th>
					<th>Amount</th>
					<th>Naration</th>
				</thead>
				<tbody>
					@foreach($summary->withdraws_list as $withdraw)
						<tr>
							<td>{{ $withdraw->person }}</td>
							<td>{{ $withdraw->amount?number_format($withdraw->amount):'0' }}</td>
							<td>{{ $withdraw->narration }}</td>
						</tr>
					@endforeach
				</tbody>
			</table>
		</div>
	</div>
</div>
@endsection