<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\api\v1\AuthController;

Route::get('/user', function (Request $request) {
    return $request->user();
})->middleware('auth:sanctum');

Route::post('/login', [AuthController::class, 'login']);

Route::resource('suppliers', \App\Http\Controllers\api\v1\SuppliersController::class);

Route::resource('customers', \App\Http\Controllers\api\v1\CustomersController::class);

Route::resource('inventories', \App\Http\Controllers\api\v1\InventoriesController::class);

Route::resource('payments', \App\Http\Controllers\api\v1\PaymentsController::class);

Route::resource('reports', \App\Http\Controllers\api\v1\ReportsController::class);