<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    return view('welcome');
});

Route::get('clean_customer_ledgers',[\App\Http\Controllers\CustomerController::class,'clean_customer_ledgers']);

Route::get('permanently_delete_ledggers',function(){
    $thirtyDaysAgo = \Carbon\Carbon::now()->subDays(2);
    \App\Models\Ledger::onlyTrashed()->where('deleted_at', '<=', $thirtyDaysAgo)->forceDelete();
});

Route::get('reject_old_recoveries',function(){
    \App\Models\Recovery::where('date', '<', '2025-02-01')
    ->where('status', '!=', 'Rejected') // Optional: prevent already rejected recoveries from being updated
    ->update(['status' => 'Rejected']);
});

Route::get('clear_dates',function(){
    $summaries = \App\Models\Summary::with('credits','collections','intakes','summary_profits','recoveries','summary_expenses','summary_transfers')->where('id',2233)->get();

    foreach($summaries as $summary){
        foreach ($summary->credits as $credit) {
            $credit->date = $summary->date;
            $credit->save();
        }

        foreach ($summary->collections as $collection) {
            $collection->date = $summary->date;
            $collection->save();
        }
        foreach ($summary->credits as $record) {
            $record->date = $summary->date;
            $record->save();
        }

        foreach ($summary->summary_discounts as $record) {
            $record->date = $summary->date;
            $record->save();
        }

        foreach ($summary->intakes as $record) {
            $record->date = $summary->date;
            $record->save();
        }

        foreach ($summary->summary_transfers as $record) {
            $record->date = $summary->date;
            $record->save();
        }

        foreach ($summary->summary_expenses as $record) {
            $record->date = $summary->date;
            $record->save();
        }

        foreach ($summary->recoveries as $record) {
            $record->date = $summary->date;
            $record->save();
        }

        foreach ($summary->summary_profits as $record) {
            $record->date = $summary->date;
            $record->save();
        }
    }
});

Route::get('clear_business_summaries',function(){
    $summaries = \App\Models\DaySummary::all();
    foreach($summaries as $summary){
        $collections = \App\Models\Collection::whereNull('customer_id')->where('date',$summary->date)->sum('amount');
        $summary->collections =  $collections + $summary->recoveries;
        $summary->save();
    }
});

Route::get('/dashboard', [\App\Http\Controllers\DashboardController::class,'index'])->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    Route::get('clean_ledger',[\App\Http\Controllers\CustomerController::class,'clean_ledger']);

    Route::resource('business', App\Http\Controllers\BusinessController::class, []);
    Route::resource('general_expenses', App\Http\Controllers\GeneralExpensesController::class, []);

    Route::resource('approvals', App\Http\Controllers\ApprovalsController::class, []);
    Route::post('approve', [App\Http\Controllers\ApprovalsController::class, 'approve'])->name('approvals.approve');
    Route::post('reject',[ App\Http\Controllers\ApprovalsController::class, 'reject'])->name('approvals.reject');
    Route::get('approval_summary',[ App\Http\Controllers\ApprovalsController::class, 'summary'])->name('approvals.summary');

    Route::post('suspense-account-transfers/{id}',[App\Http\Controllers\CustomerController::class,'suspense_account_transfers']);

    Route::resource('branches', App\Http\Controllers\BranchController::class, []);
    //@softdelete
    Route::put('branches/{branch}/restore', [App\Http\Controllers\BranchController::class, 'restore'])->name('branches.restore');
    Route::delete('branches/{branch}/purge', [App\Http\Controllers\BranchController::class, 'purge'])->name('branches.purge');

    Route::resource('expense_items', App\Http\Controllers\ExpenseItemsController::class, []);
    //@softdelete
    Route::put('expense_items/{expense_item}/restore', [App\Http\Controllers\ExpenseItemsController::class, 'restore'])->name('expense_items.restore');
    Route::delete('expense_items/{expense_item}/purge', [App\Http\Controllers\ExpenseItemsController::class, 'purge'])->name('expense_items.purge');

    Route::resource('inventories', App\Http\Controllers\InventoryController::class, []);
    //@softdelete
    Route::put('inventories/{inventory}/restore', [App\Http\Controllers\InventoryController::class, 'restore'])->name('inventories.restore');
    Route::delete('inventories/{inventory}/purge', [App\Http\Controllers\InventoryController::class, 'purge'])->name('inventories.purge');

    Route::resource('personels', App\Http\Controllers\PersonelController::class, []);
    //@softdelete
    Route::put('personels/{personel}/restore', [App\Http\Controllers\PersonelController::class, 'restore'])->name('personels.restore');
    Route::delete('personels/{personel}/purge', [App\Http\Controllers\PersonelController::class, 'purge'])->name('personels.purge');

    Route::resource('summaries', App\Http\Controllers\SummariesController::class, []);
    //@softdelete
    Route::put('summaries/{summary}/restore', [App\Http\Controllers\SummariesController::class, 'restore'])->name('summaries.restore');
    Route::delete('summaries/{summary}/purge', [App\Http\Controllers\SummariesController::class, 'purge'])->name('summaries.purge');

    Route::get('summaries/summary/{summary_id}', [App\Http\Controllers\SummariesController::class,'summary'])->name('business_summary_pending');
    Route::POST('complete_summary', [App\Http\Controllers\SummariesController::class,'complete_summary']);

    Route::resource('collections', App\Http\Controllers\CollectionsController::class);

    Route::resource('discounts', App\Http\Controllers\DiscountsController::class);

    Route::resource('disbursements', App\Http\Controllers\DisbursementsController::class);

    Route::resource('intakes', App\Http\Controllers\IntakesController::class);

    Route::get('customer_ledger', [\App\Http\Controllers\CustomerController::class,'ledger']);

    Route::get('supplier_ledger', [\App\Http\Controllers\SupplierController::class,'ledger']);

    Route::delete('delete_ledger/{ledger_id}',[\App\Http\Controllers\CustomerController::class,'delete_ledger'])->name('delete_ledger');

    Route::resource('profits', App\Http\Controllers\ProfitsController::class);

    Route::resource('transfers', App\Http\Controllers\TransfersController::class);

    Route::resource('credits', App\Http\Controllers\CreditsController::class);

    Route::resource('expenses', App\Http\Controllers\ExpensesController::class);
    Route::resource('payments', App\Http\Controllers\PaymentsController::class);
    Route::resource('payment_methods', App\Http\Controllers\PaymentMethodsController::class);

    Route::resource('customers', App\Http\Controllers\CustomerController::class, []);
    //@softdelete
    Route::put('customers/{customer}/restore', [App\Http\Controllers\CustomerController::class, 'restore'])->name('customers.restore');
    Route::delete('customers/{customer}/purge', [App\Http\Controllers\CustomerController::class, 'purge'])->name('customers.purge');

    Route::resource('purchases', \App\Http\Controllers\PurchasesController::class);
    Route::get('approve_purchase/{id}', [\App\Http\Controllers\PurchasesController::class,'approve']);

    Route::resource('users', \App\Http\Controllers\UsersController::class);
    Route::post('user_permissions',[\App\Http\Controllers\UsersController::class,'user_permissions']);

    Route::resource('recoveries', \App\Http\Controllers\RecoveriesController::class);

    Route::resource('suppliers', App\Http\Controllers\SupplierController::class, []);
    Route::resource('withdraws', App\Http\Controllers\WithdrawsController::class, []);
    //@softdelete
    Route::put('suppliers/{supplier}/restore', [App\Http\Controllers\SupplierController::class, 'restore'])->name('suppliers.restore');
    Route::delete('suppliers/{supplier}/purge', [App\Http\Controllers\SupplierController::class, 'purge'])->name('suppliers.purge');

    Route::get('download_suppliers',[App\Http\Controllers\SupplierController::class,'download']);

    Route::get('download_customers',[App\Http\Controllers\CustomerController::class,'download']);

    Route::get('summaries/modules/{summary_id}', [App\Http\Controllers\SummariesController::class, 'modules']);
});

require __DIR__.'/auth.php';
