<?php $__env->startSection('branches.content'); ?>
<div class="container">
    <div class="card">
        <div class="card-header d-flex flex-row align-items-center justify-content-between">
            <ol class="breadcrumb m-0 p-0">
                <li class="breadcrumb-item"><a href="<?php echo e(implode('/', ['','branches'])); ?>"> Branches</a></li>
                <li class="breadcrumb-item"><?php echo app('translator')->get('Branch'); ?> #<?php echo e($branch->id); ?></li>
            </ol>

            <a href="<?php echo e(route('branches.index', [])); ?>" class="btn btn-light"><i class="fa fa-caret-left"></i> Back</a>
        </div>

        <div class="card-body">
            <table class="table table-striped">
                <tbody>
                    <tr>
                        <th scope="row">Name:</th>
                        <td><?php echo e($branch->name ?: "-"); ?></td>
                    </tr>
                </tbody>
            </table>

        </div>

        <div class="card-footer d-flex flex-column flex-md-row align-items-center justify-content-end">
            <a href="<?php echo e(route('branches.edit', compact('branch'))); ?>" class="btn btn-info text-nowrap me-1"><i class="fa fa-edit"></i> <?php echo app('translator')->get('Edit'); ?></a>
            <form action="<?php echo e(route('branches.destroy', compact('branch'))); ?>" method="POST" class="m-0 p-0">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <button type="submit" class="btn btn-danger text-nowrap"><i class="fa fa-trash"></i> <?php echo app('translator')->get('Delete'); ?></button>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('branches.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/angus/public_html/warmth/resources/views/branches/show.blade.php ENDPATH**/ ?>