<?php $__env->startSection('breadcrumb'); ?>
<div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
	<h4 class="mb-sm-0">Daily Summaries</h4>
	<div class="page-title-right">
		<ol class="breadcrumb m-0">
			<li class="breadcrumb-item"><a href="<?php echo e(url('dashboard')); ?>">Dashboard</a></li>
			<li class="breadcrumb-item active">Daily Summaries</li>
		</ol>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div>
	<div class="card">
		<div class="card-header d-flex flex-row align-items-center justify-content-between">
			<h5>Summaries</h5>
			<a href="<?php echo e(url('summaries/create')); ?>" class="btn btn-primary">Create New Summary</a>
		</div>
		<div class="card-body">
			
			<div class="table-responsive">
				<table id="records-table" class="table table-bordered table-striped">
	                <thead>
	                    <tr>
	                    	<th>Rec ID</th>
	                        <th>Branch</th>
	                        <th>Date</th>
	                        <th>Personnel</th>
	                        <th>Opening Balance</th>
	                        <th>Closing Balance</th>
	                        <th>User</th>
	                        <th>Actions</th>
	                    </tr>
	                </thead>
	                <tbody>
	                    <!-- DataTables will populate this -->
	                </tbody>
	            </table>
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('customjs'); ?>
<script>
$(document).ready(function() {
    $('#records-table').DataTable({
        processing: true,
        serverSide: true,
        ajax: "<?php echo e(route('summaries.index')); ?>", // Replace with your actual route
        columns: [
        	{ data: 'id', name: 'id'},
            { data: 'branch_name', name: 'branch_name' },
            { data: 'date', name: 'date' },
            { data: 'personel', name: 'personel' },
            { data: 'opening_balance', name: 'opening_balance' },
            { data: 'closing_balance', name: 'closing_balance' },
            { data: 'user', name: 'user' },
            { data: 'actions', name: 'actions', orderable: false, searchable: false }
        ],
        order: [[0, 'desc']] // Default order by date
    });

});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/angus/public_html/warmth/resources/views/summaries/index.blade.php ENDPATH**/ ?>