<?php $__env->startSection('content'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<div class="col-md-6 mx-auto">
    <form class="">
    	<?php if(isset($customers)): ?>
        <select class="select2" name="customer_id" id="customer_id">
            <option value="">Select Customer</option>
            <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($customer->id); ?>" <?php echo e(($customer_id == $customer->id)?'selected':''); ?>><?php echo e($customer->name); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
        <?php endif; ?>
        <?php if(isset($suppliers)): ?>
        <select class="select2" name="supplier_id" id="supplier_id" style="margin-top: 10px;">
            <option value="">Select Supplier</option>
            <?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($supplier->id); ?>" <?php echo e(($supplier_id == $supplier->id)?'selected':''); ?>><?php echo e($supplier->name); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
        <?php endif; ?>
        <button type="submit" class="btn btn-primary" style="margin-top: 10px;">Get Ledger <?php echo e(($entries) ? ' ('.$entries->count().')' : ''); ?></button>

        <button class="btn btn-info" name="export" value="pdf" style="margin-top: 10px;">Export</button>

        <?php if(isset($customer_id)): ?>
            <a href="<?php echo e(url('clean_ledger/?customer_id='.$customer_id)); ?>" class="btn btn-danger" style="margin-top: 10px;">Clean Customer Ledger</a>
        <?php elseif(isset($supplier_id)): ?>
            <a href="<?php echo e(url('clean_ledger/?supplier_id='.$supplier_id)); ?>" class="btn btn-danger" style="margin-top: 10px;">Clean Supplier Ledger</a>
        <?php endif; ?>
    </form>
</div>
<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Label</th>
                        <th>Module</th>
                        <th>Credit</th>
                        <th>Debit</th>
                        <th>Balance</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if($entries): ?>
                        <?php $__currentLoopData = $entries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $entry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="<?php echo e($entry->deletable ? 'table-danger' : ''); ?>">
                                <td><?php echo e(date('d M, Y', strtotime($entry->date))); ?></td>
                                <td><?php echo e($entry->label); ?></td>
                                <td><?php echo e($entry->module); ?></td>
                                <td><?php echo e($entry->credit ? number_format($entry->credit) : '-'); ?></td>
                                <td><?php echo e($entry->debit ? number_format($entry->debit) : '-'); ?></td>
                                <td><?php echo e($entry->balance ? number_format($entry->balance) : '-'); ?></td>
                                <td><?php echo e($entry->status); ?></td>
                                <td>
                                    <?php if($entry->deletable): ?>
                                        <form action="<?php echo e(route('delete_ledger', $entry->id)); ?>" method="POST" id="delete-form-<?php echo e($entry->id); ?>" style="display: inline;">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="button" class="btn btn-danger btn-sm delete-button" data-id="<?php echo e($entry->id); ?>" data-label="<?php echo e($entry->label); ?>">
                                                Delete
                                            </button>
                                        </form>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<script>
    document.addEventListener("DOMContentLoaded", function () {
        // Add click event listeners to delete buttons
        document.querySelectorAll('.delete-button').forEach(button => {
            button.addEventListener('click', function () {
                const entryId = this.dataset.id;
                const entryLabel = this.dataset.label;

                // Show confirmation dialog
                Swal.fire({
                    title: 'Are you sure?',
                    text: `You are about to delete "${entryLabel}". "${entryId}" This action cannot be undone.`,
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Delete',
                    cancelButtonText: 'Cancel',
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    reverseButtons: true // Ensures positive button is on the right
                }).then((result) => {
                    if (result.isConfirmed) {
                        // Submit the form if confirmed
                        document.getElementById(`delete-form-${entryId}`).submit();
                    }
                });
            });
        });

        // Ensure only one select is filled
        document.getElementById('customer_id').addEventListener('change', function() {
            if (this.value) {
                document.getElementById('supplier_id').value = '';
            }
        });
        document.getElementById('supplier_id').addEventListener('change', function() {
            if (this.value) {
                document.getElementById('customer_id').value = '';
            }
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/angus/public_html/warmth/resources/views/customers/ledgers.blade.php ENDPATH**/ ?>