<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header">
        <h5><?php echo e(__("Approval Requests Summary")); ?></h5>
        <form action="<?php echo e(route('approvals.summary')); ?>" method="GET" class="mt-2">
            <div class="input-group">
                <input type="date" name="date" class="form-control" value="<?php echo e(request('date', date('Y-m-d'))); ?>">
                <button type="submit" class="btn btn-primary">Filter</button>
            </div>
        </form>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-3">
                <div class="card">
                    <div class="card-body">
                        <h5>Total Requests</h5>
                        <p>Count: <?php echo e($approvalsSummary->total_count); ?></p>
                        <p>Amount: <?php echo e(number_format($approvalsSummary->total_sum, 2)); ?></p>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card">
                    <div class="card-body">
                        <h5>Approved Requests</h5>
                        <p>Count: <?php echo e($approvalsSummary->approved_count); ?></p>
                        <p>Amount: <?php echo e(number_format($approvalsSummary->approved_sum, 2)); ?></p>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card">
                    <div class="card-body">
                        <h5>Pending Requests</h5>
                        <p>Count: <?php echo e($approvalsSummary->pending_count); ?></p>
                        <p>Amount: <?php echo e(number_format($approvalsSummary->pending_sum, 2)); ?></p>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card">
                    <div class="card-body">
                        <h5>Rejected Requests</h5>
                        <p>Count: <?php echo e($approvalsSummary->rejected_count); ?></p>
                        <p>Amount: <?php echo e(number_format($approvalsSummary->rejected_sum, 2)); ?></p>
                    </div>
                </div>
            </div>
        </div>
         <div class="mt-2">
            <input type="text" id="search-input" class="form-control" placeholder="Search...">
        </div>

        <div class="table-responsive mt-4">
            <table class="table table-striped" id="approvals-table">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Type</th>
                        <th>Customer/Supplier</th>
                        <th>Amount</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $approvals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $approval): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($approval->date); ?></td>
                            <td><?php echo e((get_class($approval) == 'App\Models\Recovery')?"Recovery":"Disbursement"); ?></td>
                            <td>
                                <?php if(get_class($approval) === 'App\Models\Recovery'): ?>
                                    <?php echo e($approval->customer->name ?? 'N/A'); ?>

                                <?php elseif(get_class($approval) === 'App\Models\Disbursement'): ?>
                                    <?php echo e($approval->supplier->name ?? 'N/A'); ?>

                                <?php else: ?>
                                    N/A
                                <?php endif; ?>
                            </td>
                            <td><?php echo e(number_format($approval->amount, 2)); ?></td>
                            <td><?php echo e($approval->status ?? 'N/A'); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('customjs'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Search functionality (client-side)
        document.getElementById('search-input').addEventListener('keyup', function() {
            const searchText = this.value.toLowerCase();
            const rows = document.querySelectorAll('#approvals-table tbody tr');

            rows.forEach(row => {
                let found = false;
                row.querySelectorAll('td').forEach(cell => {
                    if (cell.textContent.toLowerCase().includes(searchText)) {
                        found = true;
                    }
                });
                row.style.display = found ? '' : 'none';
            });
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/angus/public_html/warmth/resources/views/approvals/summary.blade.php ENDPATH**/ ?>