<?php $__env->startSection('breadcrumb'); ?>
<div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
    <h4 class="mb-sm-0">Daily Summaries</h4>
    <div class="page-title-right">
        <ol class="breadcrumb m-0">
            <li class="breadcrumb-item"><a href="<?php echo e(url('dashboard')); ?>">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="<?php echo e(url('summaries')); ?>">Daily Summaries</a></li>
            <li class="breadcrumb-item"><a href="javascript:void(0);"><?php echo e($summary->branch?->name); ?></a></li>
            <li class="breadcrumb-item"><a href="<?php echo e(url('summaries/modules/'.$summary->id)); ?>"><?php echo e(date('d M, Y',strtotime($summary->date))); ?></a></li>
            <li class="breadcrumb-item active">Recoveries</li>
        </ol>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header">
        <?php echo $__env->make('layouts.summaries_menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
    <div class="card-body">
        <form id="creditForm" action="<?php echo e(url('recoveries')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="summary_id" value="<?php echo e($summary->id); ?>">
            <div class="repeater">
                <table class="table">
                    <thead>
                        <tr>
                        	<th width="40%">Personel</th>
                            <th width="40%">Customer</th>
                            <th>Amount</th>
                        </tr>
                    </thead>
                    <tbody data-repeater-list="items">
                        <tr data-repeater-item>
                            <td>
                                <select class="form-control personel_id form-select select2" name="personel_id" required>
                                    <option></option>
                                    <?php $__currentLoopData = $personels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $personel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($personel->id); ?>"><?php echo e($personel->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </td>
                            <td>
                                <select class="form-control customer_id form-select select2" name="customer_id" required>
                                    <option></option>
                                    <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($customer->id); ?>"><?php echo e($customer->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </td>
                            <td>
                                <input type="text" name="amount" class="form-control amount" required>
                                <div class="text-end">
                                    <button type="button" data-repeater-delete class="btn btn-danger" aria-label="Delete">Delete</button>
                                </div>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <button type="button" data-repeater-create class="btn btn-primary">Add</button>
            </div>
            <div class="mt-4">
                <div class="row">
                    <div class="col-md-3 offset-md-9">
                        <div class="form-group">
                            <label for="grand-total">Grand Total:</label>
                            <input type="text" id="grand-total" class="form-control" disabled>
                        </div>
                    </div>
                </div>
            </div>
            <div class="d-flex flex-row align-items-center justify-content-between">
                <a href="<?php echo e(url('collections/create')); ?>?summary_id=<?php echo e($summary->id); ?>" class="btn btn-info">Back</a>
                <button type="button" id="previewButton" class="btn btn-success">Save</button>
            </div>
        </form>
    </div>
</div>

<!-- Preview Modal -->
<div class="modal fade" id="previewModal" tabindex="-1" aria-labelledby="previewModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="previewModalLabel">Preview Entries</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Personel</th>
                            <th>Customer</th>
                            <th>Amount</th>
                        </tr>
                    </thead>
                    <tbody id="previewBody">
                        <!-- Entries will be populated here -->
                    </tbody>
                </table>
                <div class="form-group mt-3">
                    <label for="modal-grand-total">Grand Total:</label>
                    <input type="text" id="modal-grand-total" class="form-control" disabled>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Back</button>
                <button type="button" id="confirmButton" class="btn btn-primary">Confirm</button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('customjs'); ?>
<script type="text/javascript">
    $(document).ready(function () {
        $('.select2').select2();

        var $repeater = $('.repeater').repeater({
            initEmpty: true,
            show: function () {
                $(this).slideDown();
                $('.select2-container').remove();
                $('.select2').select2();
                bindEvents($(this));
            },
            hide: function (deleteElement) {
                $(this).slideUp(deleteElement, function() {
                    $(this).remove();
                    calculateGrandTotal();
                });
            }
        });

        <?php if(old('items')): ?>
            $repeater.setList(<?php echo json_encode(old('items'), 15, 512) ?>);
        <?php elseif($recoveries->count() > 0): ?>
            $repeater.setList([
                <?php $__currentLoopData = $recoveries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $credit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                {
                    'customer_id' : '<?php echo e($credit->customer_id); ?>',
                    'personel_id' : '<?php echo e($credit->personel_id); ?>',
                    'amount': '<?php echo e($credit->amount); ?>',
                },
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            ]);
        <?php endif; ?>

        calculateGrandTotal();

        $('.repeater [data-repeater-item]').each(function() {
            bindEvents($(this));
        });

        function bindEvents(item) {
            item.find('.amount').on('input', function() {
                formatNumber($(this));
                calculateGrandTotal();
            });
        }

        function formatNumber(input) {
            var value = input.val().replace(/,/g, '');
            if (!isNaN(value) && value !== '') {
                value = parseFloat(value).toLocaleString();
                input.val(value);
            }
        }

        function calculateGrandTotal() {
            var grandTotal = 0;
            $('.repeater .amount').each(function() {
                var value = $(this).val().replace(/,/g, '');
                var total = parseFloat(value) || 0;
                grandTotal += total;
            });
            $('#grand-total').val(grandTotal.toLocaleString());
        }

        // Show Preview Modal
        $('#previewButton').on('click', function () {
            var previewBody = $('#previewBody');
            previewBody.empty();

            $('.repeater [data-repeater-item]').each(function() {
                var customer = $(this).find('.customer_id option:selected').text();
                var personel = $(this).find('.personel_id option:selected').text();
                var amount = $(this).find('.amount').val();

                previewBody.append('<tr>'+
                        '<td>'+personel+'</td>'+
                        '<td>'+customer+'</td>'+
                        '<td>'+amount+'</td>'+
                    '</tr>'
                );
            });

            $('#modal-grand-total').val($('#grand-total').val());
            $('#previewModal').modal('show');
        });

        // Confirm and Submit Form
        $('#confirmButton').on('click', function () {
            $('#creditForm').submit();
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/angus/public_html/warmth/resources/views/recoveries/create.blade.php ENDPATH**/ ?>