<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header">
        <h5><?php echo e(__("Pending Approvals")); ?></h5>
        <div class="mt-2">
            <input type="text" id="search-input" class="form-control" placeholder="Search...">
        </div>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-striped" id="approvals-table">
                <thead>
                    <th>Date</th>
                    <th>Type</th>
                    <th>Customer / Supplier</th>
                    <th>Payment Method</th>
                    <th>Amount</th>
                    <th>Actions</th>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $approvals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $approval): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e(date('d-M-Y', strtotime(($approval->date)?:$approval->expense_date))); ?></td>
                            <td>
                                <?php if($approval->recovery_id): ?>
                                Recovery
                                <?php elseif($approval->disbursement_id): ?>
                                Disbursement
                                <?php elseif($approval->expense_date): ?>
                                General Expense
                                <?php else: ?>
                                Payment
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php echo e(($approval->customer_id) ? $approval->customer?->name.'(C)' : $approval->supplier?->name.'(S)'); ?>

                            </td>
                            <td>
                                <?php echo e(($approval->payment_method_id) ? $approval->payment_method?->name : 'Cash'); ?>

                            </td>
                            <td>
                                <?php echo e(number_format($approval->amount, 2)); ?>

                            </td>
                            <td>
                                <form action="<?php echo e(route('approvals.approve', ['id' => $approval->id])); ?>" method="POST" style="display: inline-block;">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="type" value="<?php echo e(($approval->expense_date) ? 'General Expense' : 'Payment'); ?>">
                                    
                                    <button type="button" class="btn btn-success btn-sm approve-button">Approve</button>
                                </form>
                                <form action="<?php echo e(route('approvals.reject', ['id' => $approval->id, 'type' => ($approval instanceof App\Models\Recovery) ? 'recovery' : 'disbursement'])); ?>" method="POST" style="display: inline-block;">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="type" value="<?php echo e(($approval->expense_date) ? 'General Expense' : 'Payment'); ?>">
                                    
                                    
                                    <button type="button" class="btn btn-danger btn-sm reject-button">Reject</button>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('customjs'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Search functionality (client-side)
        document.getElementById('search-input').addEventListener('keyup', function() {
            const searchText = this.value.toLowerCase();
            const rows = document.querySelectorAll('#approvals-table tbody tr');

            rows.forEach(row => {
                let found = false;
                row.querySelectorAll('td').forEach(cell => {
                    if (cell.textContent.toLowerCase().includes(searchText)) {
                        found = true;
                    }
                });
                row.style.display = found ? '' : 'none';
            });
        });

        document.querySelectorAll('.approve-button').forEach(button => {
            button.addEventListener('click', function() {
                const id = this.dataset.id;
                const type = this.dataset.type;
                Swal.fire({
                    title: 'Are you sure?',
                    text: 'You are about to approve this request.',
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, approve it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        const form = this.closest('form');
                        form.submit();
                    }
                });
            });
        });

        document.querySelectorAll('.reject-button').forEach(button => {
            button.addEventListener('click', function() {
                const id = this.dataset.id;
                const type = this.dataset.type;
                Swal.fire({
                    title: 'Are you sure?',
                    text: 'You are about to reject this request.',
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, reject it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        const form = this.closest('form');
                        form.submit();
                    }
                });
            });
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/angus/public_html/warmth/resources/views/approvals/index.blade.php ENDPATH**/ ?>