<?php $__env->startSection('customers.content'); ?>
<div class="container">
    <div class="card">
        <div class="card-body">
            <!-- Nav tabs -->
            <ul class="nav nav-pills nav-justified mb-3" role="tablist">
                <li class="nav-item waves-effect waves-light">
                    <a class="nav-link active" data-bs-toggle="tab" href="#pill-justified-home-1" role="tab">
                        Supplier Details
                    </a>
                </li>
                <li class="nav-item waves-effect waves-light">
                    <a class="nav-link" data-bs-toggle="tab" href="#pill-justified-profile-1" role="tab">
                        Intakes
                    </a>
                </li>
                <li class="nav-item waves-effect waves-light">
                    <a class="nav-link" data-bs-toggle="tab" href="#pill-justified-messages-1" role="tab">
                        Payments
                    </a>
                </li>
                
            </ul>
            <!-- Tab panes -->
            <div class="tab-content ">
                <div class="tab-pane active" id="pill-justified-home-1" role="tabpanel">
                    <table class="table table-striped">
                        <tbody>
                            <tr>
                                <th scope="row">ID:</th>
                                <td><?php echo e($supplier->id); ?></td>
                            </tr>
                            <tr>
                                <th scope="row">Name:</th>
                                <td><?php echo e($supplier->name ?: "-"); ?></td>
                            </tr>
                            <tr>
                                <th scope="row">Contact:</th>
                                <td><?php echo e($supplier->contact ?: "-"); ?></td>
                            </tr>
                            <tr>
                                <th scope="row">Alt Contact:</th>
                                <td><?php echo e($supplier->alt_contact ?: "-"); ?></td>
                            </tr>
                            <tr>
                                <th scope="row">Balance:</th>
                                <td><?php echo e($supplier->balance ?: "-"); ?></td>
                            </tr>
                            <tr>
                                <th scope="row">Created at</th>
                                <td><?php echo e(Carbon\Carbon::parse($supplier->created_at)->format('d/m/Y H:i:s')); ?></td>
                            </tr>
                            <tr>
                                <th scope="row">Updated at</th>
                                <td><?php echo e(Carbon\Carbon::parse($supplier->updated_at)->format('d/m/Y H:i:s')); ?></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div class="tab-pane" id="pill-justified-profile-1" role="tabpanel">
                    <div class="table-responsive">
                        <table class="table dataTable">
                            <thead>
                                <th>Date</th>
                                <th>Branch</th>
                                <th>Inventory Item</th>
                                <th>Rate</th>
                                <th>Quantity</th>
                                <th>Amount</th>
                                <th></th>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $supplier->intakes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $intake): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e(date('d-M-Y',strtotime($intake->date))); ?></td>
                                        <td><?php echo e($intake->branch?->name); ?></td>
                                        <td><?php echo e($intake->inventory?->name); ?></td>
                                        <td><?php echo e($intake->rate ? number_format($intake->supplier_rate) : 0); ?></td>
                                        <td><?php echo e($intake->quantity ? number_format($intake->quantity) : 0); ?></td>
                                        <td>UGX <?php echo e((($intake->amount)?number_format($intake->supplier_rate * $intake->quantity) : 0)); ?></td>
                                        <td>
                                            <a href="<?php echo e(url('intakes/'.$intake->id.'/edit')); ?>" class="btn btn-primary btn-sm">Edit</a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="tab-pane" id="pill-justified-messages-1" role="tabpanel">
                    <div class="text-end">
                        <a class="btn btn-secondary mb-3" href="<?php echo e(url('payments/create')); ?>?supplier_id=<?php echo e($supplier->id); ?>">Add Payment</a>
                    </div>
                     <div class="table-responsive">
                        <table class="table dataTable">
                            <thead>
                                <th>Date</th>
                                <th>Amount</th>
                                <th>Balance</th>
                                <th></th>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $supplier->payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e(date('d-M-Y',strtotime($payment->date))); ?></td>
                                        <td><?php echo e((($payment->amount)?number_format($payment->amount) : '0')); ?></td>
                                        <td><?php echo e((($payment->amount)?number_format($payment->balance):'0')); ?></td>
                                        <td>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit payments')): ?>
                                            <a href="<?php echo e(url('payments/'.$payment->id.'/edit')); ?>" class="btn btn-primary btn-sm">Edit</a>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                
            </div>
        </div>
        <div class="card-footer d-flex flex-column flex-md-row align-items-center justify-content-end">
            <a href="<?php echo e(route('suppliers.edit', compact('supplier'))); ?>" class="btn btn-info text-nowrap me-1"><i class="fa fa-edit"></i> <?php echo app('translator')->get('Edit'); ?></a>
            <form action="<?php echo e(route('suppliers.destroy', compact('supplier'))); ?>" method="POST" class="m-0 p-0">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <button type="submit" class="btn btn-danger text-nowrap"><i class="fa fa-trash"></i> <?php echo app('translator')->get('Delete'); ?></button>
            </form>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('customers.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/angus/public_html/warmth/resources/views/suppliers/show.blade.php ENDPATH**/ ?>