<?php $__env->startSection('content'); ?>
<div class="card">
	<form class="card-body">
		<div class="row">
			<div class="col-md-4">
				<label>Date</label>
				<input type="date" class="form-control" name="date">
			</div>
			<div class="col-md-4">
				<label>Inventory</label>
				<select class="select2" name="inventory_id">
					<option></option>
					<?php $__currentLoopData = $inventories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inventory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<option value="<?php echo e($inventory->id); ?>"><?php echo e($inventory->name); ?></option>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				</select>
			</div>

			<div class="col-md-4">
				<label>Supplier</label>
				<select class="select2" name="supplier_id">
					<option></option>
					<?php $__currentLoopData = $sources; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $source): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<option value="<?php echo e($source['id']); ?>"><?php echo e($source['name']); ?></option>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				</select>
			</div>

			<div class="col-md-4">
				<label>Branch</label>
				<select class="select2" name="branch_id">
					<option></option>
					<?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<option value="<?php echo e($branch->id); ?>"><?php echo e($branch->name); ?></option>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				</select>
				<div class="text-end">
					<button type="submit" class="btn btn-success">Search</button>
				</div>
			</div>
		</div>
	</form>
</div>
<div class="card">
	<div class="card-header">
		<h5 class="card-title">Intakes</h5>
	</div>
	<div class="card-body">
		<div class="table-responsive">
			<table class="table dataTable">
				<thead>
					<th>Date</th>
					<th>Branch</th>
					<th>Source</th>
					<th>Inventory</th>
					<th>Rate</th>
					<th>Quantity</th>
					<th>Amount</th>
				</thead>
				<tbody>
					<?php $__currentLoopData = $intakes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $intake): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<tr>
							<td><?php echo e(date('d M, Y',strtotime($intake->date))); ?></td>
							<td><?php echo e($intake?->summary?->branch?->name); ?></td>
							<td><?php echo e($intake->supplier_id ? $intake->supplier?->name : $intake->branch?->name); ?></td>
							<td>
								<?php echo e($intake->inventory?->name); ?>

							</td>
							<td><?php echo e($intake->rate ? number_format($intake->rate) : 0); ?></td>
							<td><?php echo e($intake->quantity ? number_format($intake->quantity) : 0); ?></td>
							<th><?php echo e($intake->amount ? number_format($intake->amount) : 0); ?></th>
						</tr>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				</tbody>
			</table>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/angus/public_html/warmth/resources/views/intakes/index.blade.php ENDPATH**/ ?>