<?php $__env->startSection('suppliers.content'); ?>
    <div class="container">
        <div class="card">
            <div class="card-header d-flex flex-row align-items-center justify-content-between">
                <ol class="breadcrumb m-0 p-0">
                    <li class="breadcrumb-item"><a href="<?php echo e(implode('/', ['','suppliers'])); ?>"> Suppliers</a></li>
                    <li class="breadcrumb-item"><?php echo app('translator')->get('Edit Supplier'); ?> #<?php echo e($supplier->id); ?></li>
                </ol>
            </div>
            <div class="card-body">
                <form action="<?php echo e(route('suppliers.update', compact('supplier'))); ?>" method="POST" class="m-0 p-0">
                    <?php echo method_field('PUT'); ?>
                    <?php echo csrf_field(); ?>
                    <div class="card-body">
                        <div class="mb-3">
        <label for="name" class="form-label">Name:</label>
        <input type="text" name="name" id="name" class="form-control" value="<?php echo e(@old('name', $supplier->name)); ?>" required/>
        <?php if($errors->has('name')): ?>
			<div class='error small text-danger'><?php echo e($errors->first('name')); ?></div>
		<?php endif; ?>
    </div>
    <div class="mb-3">
        <label for="contact" class="form-label">Contact:</label>
        <input type="text" name="contact" id="contact" class="form-control" value="<?php echo e(@old('contact', $supplier->contact)); ?>" required/>
        <?php if($errors->has('contact')): ?>
			<div class='error small text-danger'><?php echo e($errors->first('contact')); ?></div>
		<?php endif; ?>
    </div>
    <div class="mb-3">
        <label for="alt_contact" class="form-label">Alt Contact:</label>
        <input type="text" name="alt_contact" id="alt_contact" class="form-control" value="<?php echo e(@old('alt_contact', $supplier->alt_contact)); ?>" />
        <?php if($errors->has('alt_contact')): ?>
			<div class='error small text-danger'><?php echo e($errors->first('alt_contact')); ?></div>
		<?php endif; ?>
    </div>
    <div class="mb-3">
        <label for="balance" class="form-label">Balance:</label>
        <input type="text" name="balance" id="balance" class="form-control" value="<?php echo e(@old('balance', $supplier->balance)); ?>" required/>
        <?php if($errors->has('balance')): ?>
			<div class='error small text-danger'><?php echo e($errors->first('balance')); ?></div>
		<?php endif; ?>
    </div>

                    </div>
                    <div class="card-footer">
                        <div class="d-flex flex-row align-items-center justify-content-between">
                            <a href="<?php echo e(route('suppliers.index', [])); ?>" class="btn btn-light">Cancel</a>
                            <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Update Supplier'); ?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('suppliers.layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/angus/public_html/warmth/resources/views/suppliers/edit.blade.php ENDPATH**/ ?>