<?php $__env->startSection('breadcrumb'); ?>
<div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
    <h4 class="mb-sm-0">Daily Summaries</h4>
    <div class="page-title-right">
        <ol class="breadcrumb m-0">
            <li class="breadcrumb-item"><a href="<?php echo e(url('dashboard')); ?>">Dashboard</a></li>
          
            <li class="breadcrumb-item active">Purchases</li>
        </ol>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header">
        
    </div>
    <div class="card-body">
        <form action="<?php echo e(url('purchases')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            
            <div  class="row">
            	<div class="col-md-4">
            		<label>Supplier</label>
            		<select class="select2" name="supplier">
            			<option selected disabled></option>
            			<?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            				<option value="<?php echo e($supplier->id); ?>"><?php echo e($supplier->name); ?></option>
            			<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            		</select>
            	</div>
            	<div class="col-md-4">
            		<label>Purchase Dates</label>
            		<input type="date" class="form-control" name="date" placeholder="Purchase Date">
            	</div>
            	<div class="col-md-4">
            		<label>Reference</label>
            		<input type="text" class="form-control" name="reference" placeholder="Purchase Reference">
            	</div>
            </div>
            <div class="repeater">
                <table class="table">
                    <thead>
                        <th width="40%">Inventory Item</th>
                        <th>Rate</th>
                        <th>Quantity</th>
                        <th>Amount</th>
                    </thead>
                    <tbody data-repeater-list="items">
                        <tr data-repeater-item>
                            <td>
                                <select class="form-control form-select select2" name="item_id" required>
                                        <option></option>
                                        <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                            </td>
                            <td>
                            	<input type="text" name="rate" class="form-control" placeholder="Rate" required>
                            </td>
                            <td>
                            	<input type="text" name="quantity" class="form-control" placeholder="Quantity" required>
                            </td>
                            <td>
                                
                                <div class="text-end">
                                    <button type="button" data-repeater-delete class="btn btn-danger">Delete</button>
                                </div>
                            </td>
                        </tr>
                    </tbody>
                </table>
                <button type="button" data-repeater-create class="btn btn-primary">Add</button>
            </div>
            <div class="mt-4">
                <div class="row">
                    <div class="col-md-3 offset-md-9">
                        <div class="form-group">
                            <label for="grand-total">Grand Total:</label>
                            <input type="text" id="grand-total" class="form-control" disabled>
                        </div>
                    </div>
                </div>
            </div>
            <div class="d-flex flex-row align-items-center justify-content-between">
                
                <button type="submit" class="btn btn-success">Save</button>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('customjs'); ?>
<script type="text/javascript">
   $(document).ready(function () {
    $('.select2').select2();

    var $repeater = $('.repeater').repeater({
        initEmpty: false,
        show: function () {
            $(this).slideDown();
            $('.select2-container').remove();
            $('.select2').select2();
            bindEvents($(this)); // Bind events on new row
        },
        hide: function (deleteElement) {
            $(this).slideUp(deleteElement, function() {
                $(this).remove();
                calculateGrandTotal();
            });
        }
    });

    <?php if(old('items')): ?>
        $repeater.setList(<?php echo json_encode(old('items'), 15, 512) ?>);
    <?php endif; ?>

    function formatNumber(input) {
        return input.replace(/\D/g, "").replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    }

    function parseNumber(input) {
        return parseFloat(input.replace(/,/g, '')) || 0;
    }

    function calculateTotal(row) {
        let rate = parseNumber(row.find('input[name="rate"]').val());
        let quantity = parseNumber(row.find('input[name="quantity"]').val());
        let amount = rate * quantity;

        row.find('input[name="amount"]').val(amount.toFixed(2));
        calculateGrandTotal();
    }

    function calculateGrandTotal() {
        let total = 0;
        $('.amount').each(function () {
            total += parseNumber($(this).val());
        });
        $('#grand-total').val(total.toLocaleString('en-US', { minimumFractionDigits: 2 }));
    }

    function bindEvents(row) {
        row.find('input[name="rate"], input[name="quantity"]').on('keyup', function () {
            let formatted = formatNumber($(this).val());
            $(this).val(formatted);
            calculateTotal(row);
        });
    }

    $('.repeater tbody tr').each(function () {
        bindEvents($(this));
    });
});

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/angus/public_html/warmth/resources/views/purchases/create.blade.php ENDPATH**/ ?>