<?php $__env->startSection('content'); ?>
<div class="card">
	<div class="card-header flex-column flex-md-row align-items-md-center justify-content-between">
		<h5>Purchase Details</h5>

		
	</div>
	<div class="card-body">
		<div class="row">
			<div class="mb-3 col-md-4">
				<label>Supplier</label>
				<div>
					<?php echo e($purchase->supplier?->name); ?>

				</div>
			</div>
			<div class="mb-3 col-md-4">
				<label>Purchase Date</label>
				<div>
					<?php echo e(date('d-M-Y',strtotime($purchase->date))); ?>

				</div>
			</div>
			<div class="mb-3 col-md-4">
				<label>Reference</label>
				<div>
					<?php echo e($purchase->reference); ?>

				</div>
			</div>
		</div>
		<div class="table-responsive">
			<table class="table table-striped">
				<thead>
					<th>Inventory Item</th>
					<th>Rate</th>
					<th>Quantity</th>
					<th>Total</th>
				</thead>
				<tbody>
					<?php $__currentLoopData = $purchase->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<tr class="">
							<td><?php echo e($item->Inventory?->name); ?></td>
							<td><?php echo e(($item->rate)? (number_format($item->rate,2)) : '-'); ?></td>
							<td><?php echo e(($item->quantity)? (number_format($item->quantity,2)) : '-'); ?></td>
							<td><?php echo e(($item->quantity)? (number_format($item->quantity * $item->rate,2)) : '-'); ?></td>
						</tr>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				</tbody>
			</table>
		</div>
	</div>
	<div class="card-footer">
		<?php if($purchase->status == "Draft"): ?>
		<a href="<?php echo e(url('approve_purchase/'.$purchase->id)); ?>" class="btn btn-danger">Approve</a>
		<?php endif; ?>
	</div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/angus/public_html/warmth/resources/views/purchases/show.blade.php ENDPATH**/ ?>